/*
 * Decompiled with CFR 0.152.
 */
package org.zenoda.secretj.admin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtPrimitiveType;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.Bytecode;
import javassist.bytecode.MethodInfo;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class Encrypt {
    private static final Logger logger = Logger.getLogger(Encrypt.class.getName());
    private static final String ALGORITHM = "AES";
    private static final ClassPool classPool = ClassPool.getDefault();

    public static void main(String[] args) {
        Options options = new Options();
        options.addOption("h", "help", false, "print this message");
        options.addOption("p", "password", true, "password");
        options.addOption("j", "jars", true, "jars for encryption");
        options.addOption("c", "classes", true, "classes for encryption");
        DefaultParser parser = new DefaultParser();
        HelpFormatter formatter = new HelpFormatter();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            logger.severe(e.getMessage());
            System.exit(1);
        }
        if (cmd.hasOption("help")) {
            formatter.printHelp("encrypt-admin", options);
        } else {
            String password = cmd.getOptionValue("password");
            String jars = cmd.getOptionValue("jars");
            String classes = cmd.getOptionValue("classes");
            String[] inputJars = jars.split(":");
            String[] classesToEncrypt = classes == null ? null : classes.split(":");
            try {
                Encrypt.encrypt(inputJars, classesToEncrypt, password);
            }
            catch (Exception e) {
                logger.severe(e.getMessage());
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    public static void encrypt(String[] inputJars, String[] classesToEncrypt, String password) throws Exception {
        SecretKeySpec secretKey = new SecretKeySpec(Encrypt.sha256(password), ALGORITHM);
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(1, secretKey);
        for (String inputJar : inputJars) {
            String outputJar = inputJar.substring(0, inputJar.lastIndexOf(".")) + "-encrypted.jar";
            JarInputStream jarInputStream = new JarInputStream(new FileInputStream(inputJar));
            Manifest manifest = jarInputStream.getManifest();
            JarOutputStream jarOutputStream = manifest == null ? new JarOutputStream(new FileOutputStream(outputJar)) : new JarOutputStream((OutputStream)new FileOutputStream(outputJar), manifest);
            try (JarInputStream jarInputStream2 = jarInputStream;
                 JarOutputStream jarOutputStream2 = jarOutputStream;){
                Encrypt.encryptStream(classesToEncrypt, jarInputStream, jarOutputStream, cipher);
            }
        }
    }

    private static void encryptStream(String[] classes, JarInputStream jarInputStream, JarOutputStream jarOutputStream, Cipher cipher) throws Exception {
        JarEntry entry = jarInputStream.getNextJarEntry();
        while (entry != null) {
            if (entry.getName().endsWith(".class") && Encrypt.isClassToEncrypt(entry.getName(), classes)) {
                logger.info("encrypt class: " + entry.getName());
                byte[] classBytes = jarInputStream.readAllBytes();
                byte[] mockBytes = Encrypt.makeMock(classBytes);
                JarEntry newEntry = Encrypt.createNewEntry(entry.getName(), entry, mockBytes);
                jarOutputStream.putNextEntry(newEntry);
                jarOutputStream.write(mockBytes);
                byte[] encryptedBytes = Encrypt.encryptClassBytes(classBytes, cipher);
                JarEntry newEncEntry = Encrypt.createNewEntry(entry.getName() + ".enc", entry, mockBytes);
                jarOutputStream.putNextEntry(newEncEntry);
                jarOutputStream.write(encryptedBytes);
            } else if (entry.getName().endsWith(".jar")) {
                ByteArrayOutputStream dataBuffStream = new ByteArrayOutputStream();
                JarInputStream newJarInputStream = new JarInputStream(jarInputStream);
                Manifest manifest = newJarInputStream.getManifest();
                try (JarOutputStream newJarOutputStream = manifest == null ? new JarOutputStream(dataBuffStream) : new JarOutputStream((OutputStream)dataBuffStream, manifest);){
                    Encrypt.encryptStream(classes, newJarInputStream, newJarOutputStream, cipher);
                }
                byte[] dataBuff = dataBuffStream.toByteArray();
                JarEntry newEntry = Encrypt.createNewEntry(entry.getName(), entry, dataBuff);
                jarOutputStream.putNextEntry(newEntry);
                jarOutputStream.write(dataBuff);
            } else if (entry.isDirectory()) {
                JarEntry newEntry = new JarEntry(entry.getName());
                jarOutputStream.putNextEntry(newEntry);
            } else {
                byte[] data = jarInputStream.readAllBytes();
                JarEntry newEntry = Encrypt.createNewEntry(entry.getName(), entry, data);
                jarOutputStream.putNextEntry(newEntry);
                jarOutputStream.write(data);
            }
            jarOutputStream.closeEntry();
            entry = jarInputStream.getNextJarEntry();
        }
    }

    private static JarEntry createNewEntry(String name, JarEntry entry, byte[] data) {
        int method = entry.getMethod();
        JarEntry newEntry = new JarEntry(name);
        newEntry.setMethod(method);
        if (method == 0) {
            newEntry.setSize(data.length);
            newEntry.setCompressedSize(data.length);
            CRC32 crc32 = new CRC32();
            crc32.update(data);
            newEntry.setCrc(crc32.getValue());
        }
        return newEntry;
    }

    private static byte[] makeMock(byte[] classBytes) throws Exception {
        CtMethod[] cms;
        CtClass cc = classPool.makeClassIfNew((InputStream)new ByteArrayInputStream(classBytes));
        if (cc.isFrozen()) {
            return cc.toBytecode();
        }
        CtField flagField = CtField.make((String)"private static final java.lang.String __ZENODAENC__=\"ENCRYPTED BY ZENODA\";", (CtClass)cc);
        cc.addField(flagField);
        for (CtMethod cm : cms = cc.getDeclaredMethods()) {
            MethodInfo methodInfo = cm.getMethodInfo();
            try {
                Bytecode b = new Bytecode(cc.getClassFile().getConstPool());
                Encrypt.makeDefaultBody(b, cc);
                methodInfo.setCodeAttribute(b.toCodeAttribute());
                methodInfo.setAccessFlags(methodInfo.getAccessFlags() & 0xFFFFFBFF);
                methodInfo.rebuildStackMapIf6(cc.getClassPool(), cc.getClassFile());
            }
            catch (BadBytecode e) {
                throw new CannotCompileException((Throwable)e);
            }
        }
        cc.rebuildClassFile();
        return cc.toBytecode();
    }

    private static void makeDefaultBody(Bytecode b, CtClass type) {
        int value;
        int op;
        if (type instanceof CtPrimitiveType) {
            CtPrimitiveType pt = (CtPrimitiveType)type;
            op = pt.getReturnOp();
            value = op == 175 ? 14 : (op == 174 ? 11 : (op == 173 ? 9 : (op == 177 ? 0 : 3)));
        } else {
            op = 176;
            value = 1;
        }
        if (value != 0) {
            b.addOpcode(value);
        }
        b.addOpcode(op);
    }

    private static byte[] sha256(String input) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            return digest.digest(input.getBytes(StandardCharsets.UTF_8));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isClassToEncrypt(String entryName, String[] classesToEncrypt) {
        if (classesToEncrypt == null) {
            return true;
        }
        for (String className : classesToEncrypt) {
            if (!entryName.contains(className = className.replaceAll("\\.", "/"))) continue;
            return true;
        }
        return false;
    }

    private static byte[] encryptClassBytes(byte[] classBytes, Cipher cipher) throws Exception {
        return cipher.doFinal(classBytes);
    }

    private static void copyInputStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int length;
        byte[] buffer = new byte[1024];
        while ((length = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, length);
        }
    }
}

