/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jrebel.gradle;

import java.io.File;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Project;
import org.gradle.tooling.BuildException;
import org.zeroturnaround.jrebel.gradle.model.RebelClasspath;
import org.zeroturnaround.jrebel.gradle.model.RebelClasspathResource;
import org.zeroturnaround.jrebel.gradle.model.RebelMainModel;
import org.zeroturnaround.jrebel.gradle.model.RebelWar;
import org.zeroturnaround.jrebel.gradle.model.RebelWeb;
import org.zeroturnaround.jrebel.gradle.model.RebelWebResource;
import org.zeroturnaround.jrebel.gradle.util.FileUtil;
import org.zeroturnaround.jrebel.gradle.util.LoggerWrapper;

public class RebelModelBuilder {
    private LoggerWrapper log;
    private final String packaging;
    private RebelClasspath classpath;
    private RebelWeb web;
    private RebelWar war;
    private List<File> defaultClassesDirectories;
    private File defaultResourcesDirectory;
    private File defaultWebappDirectory;
    private String configuredRootPath;
    private File configuredRelativePath;
    private File projectDir;

    public RebelModelBuilder(Project project, String packaging, RebelClasspath classpath, RebelWeb web, RebelWar war, List<File> defaultClassesDirectories, File defaultResourcesDirectory, File defaultWebappDirectory, String configuredRootPath, File configuredRelativePath, File projectDir) {
        this.log = new LoggerWrapper(project.getLogger());
        this.packaging = packaging;
        this.classpath = classpath;
        this.web = web;
        this.war = war;
        this.defaultClassesDirectories = defaultClassesDirectories;
        this.defaultResourcesDirectory = defaultResourcesDirectory;
        this.defaultWebappDirectory = defaultWebappDirectory;
        this.configuredRootPath = configuredRootPath;
        this.configuredRelativePath = configuredRelativePath;
        this.projectDir = projectDir;
    }

    public RebelMainModel build() {
        RebelMainModel rebelMainModel;
        if ("jar".equals(this.packaging)) {
            rebelMainModel = this.buildModelForJar();
        } else if ("war".equals(this.packaging)) {
            rebelMainModel = this.buildModelForWar();
        } else {
            throw new IllegalArgumentException("Illegal packaging type value '" + this.packaging + "'. Supported values are 'jar' and 'war'");
        }
        return rebelMainModel;
    }

    private RebelMainModel buildModelForJar() {
        this.log.info("Building rebel backend model for jar ..");
        RebelMainModel model = new RebelMainModel();
        this.buildClasspath(model);
        this.log.info("Backend model eventually built: " + model);
        return model;
    }

    private RebelMainModel buildModelForWar() {
        this.log.info("Building rebel backend model for war ..");
        RebelMainModel model = new RebelMainModel();
        this.buildWeb(model);
        this.buildClasspath(model);
        this.buildWar(model);
        this.log.info("Backend model eventually built: " + model);
        return model;
    }

    private void buildClasspath(RebelMainModel model) {
        if (this.classpath == null) {
            this.log.info("No custom classpath configuration found .. using the defaults");
            this.buildDefaultClasspath(model, null);
        } else {
            boolean addDefaultAsFirst = true;
            RebelClasspathResource defaultClasspath = null;
            for (RebelClasspathResource resource : this.classpath.getResources()) {
                if (!resource.isDefaultClasspathElement()) continue;
                addDefaultAsFirst = false;
                defaultClasspath = resource;
                break;
            }
            if (addDefaultAsFirst) {
                this.buildDefaultClasspath(model, defaultClasspath);
            }
            for (RebelClasspathResource resource : this.classpath.getResources()) {
                if (resource.isDefaultClasspathElement()) {
                    this.buildDefaultClasspath(model, resource);
                    continue;
                }
                resource.setDirectory(this.fixFilePath(resource.getDirectory()));
                model.addClasspathDir(resource);
            }
        }
    }

    private void buildDefaultClasspath(RebelMainModel model, RebelClasspathResource defaultClasspath) throws BuildException {
        if (this.classpath == null || !this.classpath.isOmitDefaultResourcesDir().booleanValue()) {
            this.addDefaultResourcesDirToClasspath(model);
        }
        if (this.classpath == null || !this.classpath.isOmitDefaultClassesDir().booleanValue()) {
            this.addDefaultClassesDirToClasspath(model, defaultClasspath);
        }
    }

    private void addDefaultClassesDirToClasspath(RebelMainModel model, RebelClasspathResource defaultClasspath) {
        for (File classesDir : this.defaultClassesDirectories) {
            RebelClasspathResource classpathResource = new RebelClasspathResource();
            String fixedDefaultClassesDirectory = this.fixFilePath(classesDir);
            this.log.info("fixed default classes directory : " + fixedDefaultClassesDirectory);
            classpathResource.setDirectory(fixedDefaultClassesDirectory);
            if (defaultClasspath != null) {
                classpathResource.setIncludes(defaultClasspath.getIncludes());
                classpathResource.setExcludes(defaultClasspath.getExcludes());
            }
            model.addClasspathDir(classpathResource);
            this.createIfDoesNotExist(classesDir);
        }
    }

    private void addDefaultResourcesDirToClasspath(RebelMainModel model) throws BuildException {
        this.log.info("Adding default resources directory to classpath ..");
        RebelClasspathResource resourcesClasspathResource = new RebelClasspathResource();
        String fixedDefaultResourcesDir = this.fixFilePath(this.defaultResourcesDirectory);
        this.log.info("Default resources directory after normalizing: " + fixedDefaultResourcesDir);
        resourcesClasspathResource.setDirectory(fixedDefaultResourcesDir);
        model.addClasspathDir(resourcesClasspathResource);
        this.createIfDoesNotExist(this.defaultResourcesDirectory);
    }

    private void buildWar(RebelMainModel model) {
        if (this.war != null) {
            if (this.war.getDir() != null) {
                this.war.setOriginalDir(this.war.getDir());
                this.war.setDir(this.fixFilePath(this.war.getDir()));
            }
            if (this.war.getFile() != null) {
                this.war.setOriginalFile(this.war.getFile());
                this.war.setFile(this.fixFilePath(this.war.getFile()));
            }
            model.setWar(this.war);
        }
    }

    private void buildWeb(RebelMainModel model) {
        if (this.web == null) {
            this.buildDefaultWeb(model, null);
        } else {
            List<RebelWebResource> resources;
            boolean addDefaultAsFirst = true;
            RebelWebResource defaultWeb = null;
            for (RebelWebResource resource : this.web.getResources()) {
                if (!resource.isDefaultElement()) continue;
                defaultWeb = resource;
                addDefaultAsFirst = false;
                break;
            }
            if (addDefaultAsFirst && this.web != null && !this.web.getOmitDefault().booleanValue()) {
                this.buildDefaultWeb(model, defaultWeb);
            }
            if ((resources = this.web.getResources()) != null && resources.size() > 0) {
                for (int i = 0; i < resources.size(); ++i) {
                    RebelWebResource resource = resources.get(i);
                    if (resource.isDefaultElement()) {
                        if (this.web.getOmitDefault().booleanValue()) continue;
                        this.buildDefaultWeb(model, resource);
                        continue;
                    }
                    resource.setDirectory(this.fixFilePath(resource.getDirectory()));
                    model.addWebResource(resource);
                }
            }
        }
    }

    private String fixFilePath(File file) {
        String relative;
        File baseDir = this.getProjectDir();
        if (file.isAbsolute() && !FileUtil.isRelativeToPath(new File(baseDir, this.getRelativePath()), file)) {
            return StringUtils.replace((String)FileUtil.getCanonicalPath(file), (String)"\\", (String)"/");
        }
        if (!file.isAbsolute()) {
            file = new File(baseDir, file.getPath());
        }
        if (!new File(relative = FileUtil.getRelativePath(new File(baseDir, this.getRelativePath()), file)).isAbsolute()) {
            return StringUtils.replace((String)this.getRootPath(), (String)"\\", (String)"/") + "/" + relative;
        }
        if (new File(this.getRootPath()).isAbsolute()) {
            String s = FileUtil.getRelativePath(new File(this.getRootPath()), file);
            if (!new File(s).isAbsolute()) {
                return StringUtils.replace((String)this.getRootPath(), (String)"\\", (String)"/") + "/" + s;
            }
            return s;
        }
        return StringUtils.replace((String)file.getAbsolutePath(), (String)"\\", (String)"/");
    }

    private File getProjectDir() {
        return this.projectDir;
    }

    private void buildDefaultWeb(RebelMainModel model, RebelWebResource defaultWeb) {
        RebelWebResource r = new RebelWebResource();
        r.setTarget("/");
        r.setDirectory(this.fixFilePath(this.defaultWebappDirectory));
        if (defaultWeb != null) {
            r.setIncludes(defaultWeb.getIncludes());
            r.setExcludes(defaultWeb.getExcludes());
        }
        model.addWebResource(r);
    }

    private String fixFilePath(String path) {
        return this.fixFilePath(new File(path));
    }

    private String getRelativePath() {
        if (this.configuredRelativePath != null) {
            return this.configuredRelativePath.getAbsolutePath();
        }
        return ".";
    }

    private String getRootPath() {
        if (this.configuredRootPath != null) {
            return this.configuredRootPath;
        }
        return this.projectDir.getAbsolutePath();
    }

    private void createIfDoesNotExist(File dir) {
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }
}

