/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jrebel.gradle;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.apache.commons.io.IOUtils;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Plugin;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.plugins.WarPluginConvention;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.tooling.BuildException;
import org.zeroturnaround.jrebel.gradle.BaseRebelGenerateTask;
import org.zeroturnaround.jrebel.gradle.RebelModelBuilder;
import org.zeroturnaround.jrebel.gradle.RebelRemoteWriter;
import org.zeroturnaround.jrebel.gradle.SourceSetDefaults;
import org.zeroturnaround.jrebel.gradle.dsl.RebelDslClasspath;
import org.zeroturnaround.jrebel.gradle.dsl.RebelDslMain;
import org.zeroturnaround.jrebel.gradle.dsl.RebelDslWar;
import org.zeroturnaround.jrebel.gradle.dsl.RebelDslWeb;
import org.zeroturnaround.jrebel.gradle.model.RebelMainModel;
import org.zeroturnaround.jrebel.gradle.model.RebelWar;
import org.zeroturnaround.jrebel.gradle.util.FileUtil;
import org.zeroturnaround.jrebel.gradle.util.LoggerWrapper;
import org.zeroturnaround.jrebel.gradle.util.RemoteUtil;

public class IncrementalRebelGenerateTask
extends DefaultTask
implements BaseRebelGenerateTask {
    private final LoggerWrapper log = new LoggerWrapper(this.getProject().getLogger());
    private final RebelDslMain rebelDsl = (RebelDslMain)this.getProject().getExtensions().getByName("rebel");
    private Provider<String> configuredRootPath;
    private Provider<File> jrebelBuildDir;
    private Provider<File> defaultWebappDirectory;
    private Provider<Collection<File>> defaultClassesDirectory;
    private Provider<File> defaultResourcesDirectory;
    private Provider<String> remoteId;
    private boolean skipWritingRebelXml;
    private RebelMainModel rebelModel;

    @Nested
    public RebelDslMain getRebelDsl() {
        return this.rebelDsl;
    }

    @Input
    @Optional
    public String getConfiguredRootPath() {
        return (String)this.configuredRootPath.getOrNull();
    }

    public void setConfiguredRootPath(Provider<String> provider) {
        this.configuredRootPath = provider;
    }

    @OutputDirectory
    public File getJRebelBuildDir() {
        return (File)this.jrebelBuildDir.get();
    }

    public void setJRebelBuildDir(Provider<File> provider) {
        this.jrebelBuildDir = provider;
    }

    @Internal
    public File getDefaultWebappDirectory() {
        return this.defaultWebappDirectory != null ? (File)this.defaultWebappDirectory.getOrNull() : null;
    }

    @Input
    @Optional
    public String getDefaultWebappDirectoryPath() {
        File webappDirectory = this.getDefaultWebappDirectory();
        return webappDirectory != null ? webappDirectory.getAbsolutePath() : null;
    }

    public void setDefaultWebappDirectory(Provider<File> provider) {
        this.defaultWebappDirectory = provider;
    }

    @Input
    @Optional
    public Collection<File> getDefaultClassesDirectory() {
        return (Collection)this.defaultClassesDirectory.getOrNull();
    }

    public void setDefaultClassesDirectory(Provider<Collection<File>> provider) {
        this.defaultClassesDirectory = provider;
    }

    @Internal
    public File getDefaultResourcesDirectory() {
        return (File)this.defaultResourcesDirectory.getOrNull();
    }

    @Input
    @Optional
    public String getDefaultResourcesDirectoryPath() {
        File resourcesDirectory = this.getDefaultResourcesDirectory();
        return resourcesDirectory != null ? resourcesDirectory.getAbsolutePath() : null;
    }

    public void setDefaultResourcesDirectory(Provider<File> provider) {
        this.defaultResourcesDirectory = provider;
    }

    @Input
    public Long getAlwaysGenerateTrigger() {
        return this.rebelDsl.getAlwaysGenerate() ? System.currentTimeMillis() : 0L;
    }

    @Override
    @TaskAction
    public void generate() {
        RebelDslMain rebelDsl = this.getRebelDsl();
        this.log.info("rebel.alwaysGenerate = " + rebelDsl.getAlwaysGenerate());
        this.log.info("rebel.showGenerated = " + rebelDsl.getShowGenerated());
        this.log.info("rebel.rebelXmlDirectory = " + rebelDsl.getRebelXmlDirectory());
        this.log.info("rebel.packaging = " + rebelDsl.getPackaging());
        this.log.info("rebel.war = " + rebelDsl.getWar());
        this.log.info("rebel.web = " + rebelDsl.getWeb());
        this.log.info("rebel.classpath = " + rebelDsl.getClasspath());
        this.log.info("rebel.remoteId = " + rebelDsl.getRemoteId());
        this.log.info("rebel.defaultClassesDirectories = " + this.getDefaultClassesDirectory());
        this.log.info("rebel.defaultResourcesDirectory = " + this.getDefaultResourcesDirectoryPath());
        this.log.info("rebel.defaultWebappDirectory = " + this.getDefaultWebappDirectoryPath());
        this.log.info("rebel.configuredRootPath = " + this.getConfiguredRootPath());
        this.log.info("rebel.configuredRelativePath = " + this.getRebelDsl().getRelativePathName());
        this.log.info("rebel.generateRebelRemote = " + this.getRebelDsl().getGenerateRebelRemote());
        this.log.info("jrebel output dir " + this.jrebelBuildDir.getOrNull());
        this.generateRebelXml();
        this.generateRemoteXml();
    }

    private void generateRebelXml() {
        if (this.skipWritingRebelXml) {
            return;
        }
        RebelDslClasspath classpath = this.getRebelDsl().getClasspath();
        RebelDslWeb web = this.getRebelDsl().getWeb();
        RebelDslWar war = this.getRebelDsl().getWar();
        this.rebelModel = new RebelModelBuilder(this.getProject(), this.getRebelDsl().getPackaging(), classpath != null ? classpath.toRebelClasspath() : null, web != null ? web.toRebelWeb() : null, war != null ? war.toRebelWar() : null, this.getDefaultClassesDirectory(), this.getDefaultResourcesDirectory(), this.getDefaultWebappDirectory(), this.getConfiguredRootPath(), this.getRebelDsl().getRelativePath(), this.getProject().getProjectDir(), (String)this.remoteId.getOrNull()).build();
        File buildDir = (File)this.jrebelBuildDir.get();
        File rebelXmlFile = new File(buildDir, "rebel.xml");
        try {
            if (!buildDir.exists() && !buildDir.mkdirs()) {
                throw new IOException("Failed to create directory for rebel.xml: " + buildDir);
            }
            this.log.info("Processing " + this.getProject().getGroup() + ":" + this.getProject().getName() + " with packaging " + this.getRebelDsl().getPackaging());
            this.log.info("Generating \"" + rebelXmlFile.getAbsolutePath() + "\"...");
            String xmlFileContents = this.rebelModel.toXmlString();
            if (this.getRebelDsl().getShowGenerated()) {
                this.log.lifecycle(xmlFileContents);
            }
            FileUtil.writeToFile(rebelXmlFile, xmlFileContents);
        }
        catch (IOException e) {
            throw new BuildException("Failed writing " + rebelXmlFile, (Throwable)e);
        }
    }

    private void generateRemoteXml() {
        if (!this.getRebelDsl().getGenerateRebelRemote()) {
            return;
        }
        File buildDir = (File)this.jrebelBuildDir.get();
        File rebelRemoteFile = new File(buildDir, "rebel-remote.xml");
        if (!buildDir.exists() && !buildDir.mkdirs()) {
            this.log.error("Failed to create directory for rebel-remote.xml: " + buildDir);
            return;
        }
        this.log.info("Generating rebel-remote.xml with id " + (String)this.remoteId.getOrNull() + " to \"" + buildDir + "\"");
        StringWriter writer = null;
        try {
            writer = new StringWriter();
            RebelRemoteWriter remoteWriter = new RebelRemoteWriter((String)this.remoteId.getOrNull());
            remoteWriter.writeXml(writer);
            String contents = ((Object)writer).toString();
            if (this.getRebelDsl().getShowGenerated()) {
                this.log.lifecycle(contents);
            }
            FileUtil.writeToFile(rebelRemoteFile, contents);
            ((Writer)writer).close();
        }
        catch (IOException e) {
            throw new BuildException("Failed writing " + rebelRemoteFile, (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    public IncrementalRebelGenerateTask() {
        this.getProject().getPlugins().withType(WarPlugin.class).all((Action)new Action<Plugin>(){

            public void execute(Plugin p) {
                IncrementalRebelGenerateTask.this.getRebelDsl().setPackaging("war");
                IncrementalRebelGenerateTask.this.setDefaultWebappDirectory((Provider<File>)IncrementalRebelGenerateTask.this.getProject().provider((Callable)new Callable<File>(){

                    @Override
                    public File call() {
                        try {
                            WarPluginConvention warConvention = (WarPluginConvention)IncrementalRebelGenerateTask.this.getProject().getConvention().getPlugin(WarPluginConvention.class);
                            return warConvention.getWebAppDir();
                        }
                        catch (Exception e) {
                            return null;
                        }
                    }
                }));
            }
        });
        this.setConfiguredRootPath((Provider<String>)this.getProject().getProviders().provider((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                String rootPathFromProjectProperties = IncrementalRebelGenerateTask.this.getProject().hasProperty("rebel.rootPath") ? IncrementalRebelGenerateTask.this.getProject().property("rebel.rootPath").toString() : null;
                String rootPath = rootPathFromProjectProperties != null ? rootPathFromProjectProperties : IncrementalRebelGenerateTask.this.getRebelDsl().getRootPath();
                return rootPath;
            }
        }));
    }

    public void configureSourceSet(final SourceSetDefaults sourceSetDefaults) {
        this.setDefaultClassesDirectory(sourceSetDefaults.classesDirs);
        this.setDefaultResourcesDirectory(sourceSetDefaults.resourcesDir);
        Provider jRebelBuildDir = this.getProject().provider((Callable)new Callable<File>(){

            @Override
            public File call() throws Exception {
                if (IncrementalRebelGenerateTask.this.getProject().hasProperty("rebel.rebelXmlDirectory")) {
                    return new File(IncrementalRebelGenerateTask.this.getProject().property("rebel.rebelXmlDirectory").toString());
                }
                File outputBase = IncrementalRebelGenerateTask.this.rebelDsl.getRebelXmlDirectory() != null ? new File(IncrementalRebelGenerateTask.this.getProject().getProjectDir(), IncrementalRebelGenerateTask.this.rebelDsl.getRebelXmlDirectory()) : new File(IncrementalRebelGenerateTask.this.getProject().getBuildDir(), "jrebel");
                if (sourceSetDefaults.xmlOutputDirName != null) {
                    return new File(outputBase, sourceSetDefaults.xmlOutputDirName);
                }
                return outputBase;
            }
        });
        this.setJRebelBuildDir((Provider<File>)jRebelBuildDir);
        this.remoteId = this.getProject().provider((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                if (IncrementalRebelGenerateTask.this.rebelDsl.getRemoteId() != null) {
                    return IncrementalRebelGenerateTask.this.rebelDsl.getRemoteId();
                }
                return RemoteUtil.getRemoteId(IncrementalRebelGenerateTask.this.getProject(), sourceSetDefaults.remoteIdSuffix);
            }
        });
    }

    @Override
    public String getPackaging() {
        return this.getRebelDsl().getPackaging();
    }

    @Override
    public void skipWritingRebelXml() {
        this.skipWritingRebelXml = true;
    }

    @Override
    public RebelMainModel getRebelModel() {
        return this.rebelModel;
    }

    @Override
    public void propagateConventionMappingSettings() {
    }

    @Override
    public boolean getShowGenerated() {
        return this.getRebelDsl().getShowGenerated();
    }

    @Override
    public boolean getAlwaysGenerate() {
        return this.getRebelDsl().getAlwaysGenerate();
    }

    @Override
    public RebelWar getWar() {
        return this.rebelModel != null ? this.rebelModel.getWar() : null;
    }
}

