/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jrebel.gradle;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.tooling.BuildException;
import org.zeroturnaround.jrebel.gradle.model.RebelClasspath;
import org.zeroturnaround.jrebel.gradle.model.RebelClasspathResource;
import org.zeroturnaround.jrebel.gradle.model.RebelMainModel;
import org.zeroturnaround.jrebel.gradle.model.RebelWar;
import org.zeroturnaround.jrebel.gradle.model.RebelWeb;
import org.zeroturnaround.jrebel.gradle.model.RebelWebResource;
import org.zeroturnaround.jrebel.gradle.util.FileUtil;
import org.zeroturnaround.jrebel.gradle.util.LoggerWrapper;

public class RebelGenerateTask
extends DefaultTask {
    public static final String PACKAGING_TYPE_JAR = "jar";
    public static final String PACKAGING_TYPE_WAR = "war";
    private LoggerWrapper log = new LoggerWrapper(this.getProject().getLogger());
    private String packaging;
    private RebelClasspath classpath;
    private RebelWeb web;
    private RebelWar war;
    private RebelMainModel rebelModel;
    private boolean skipWritingRebelXml;
    private Boolean alwaysGenerate;
    private File defaultClassesDirectory;
    private File defaultResourcesDirectory;
    private File defaultWebappDirectory;
    private Boolean showGenerated;
    private File rebelXmlDirectory;
    private Boolean isPluginConfigured = false;
    private String configuredRootPath;
    private File configuredRelativePath;
    public static final String NAME_DEFAULT_CLASSES_DIRECTORY = "defaultClassesDirectory$MAGIC";
    public static final String NAME_DEFAULT_RESOURCES_DIRECTORY = "defaultResourcesDirectory$MAGIC";
    public static final String NAME_DEFAULT_WEBAPP_DIRECTORY = "defaultWebappDirectory$MAGIC";
    public static final String NAME_REBEL_XML_DIRECTORY = "rebelXmlDirectory$MAGIC";

    public String getConfiguredRootPath() {
        return this.configuredRootPath;
    }

    public void setConfiguredRootPath(String path) {
        this.configuredRootPath = path;
    }

    public File getConfiguredRelativePath() {
        return this.configuredRelativePath;
    }

    public void setConfiguredRelativePath(File path) {
        this.configuredRelativePath = path;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public void setPackaging(String packaging) {
        this.packaging = packaging;
    }

    public Boolean getShowGenerated() {
        return this.showGenerated;
    }

    public void setShowGenerated(Boolean showGenerated) {
        this.showGenerated = showGenerated;
    }

    public RebelClasspath getClasspath() {
        return this.classpath;
    }

    public void setClasspath(RebelClasspath path) {
        this.classpath = path;
    }

    public RebelWeb getWeb() {
        return this.web;
    }

    public void setWeb(RebelWeb web) {
        this.web = web;
    }

    public RebelWar getWar() {
        return this.war;
    }

    public void setWar(RebelWar _war) {
        this.war = _war;
    }

    public Boolean getAlwaysGenerate() {
        return this.alwaysGenerate;
    }

    public void setAlwaysGenerate(Boolean _alwaysGenerate) {
        this.alwaysGenerate = _alwaysGenerate;
    }

    public File getDefaultClassesDirectory() {
        return this.defaultClassesDirectory;
    }

    public File getDefaultResourcesDirectory() {
        return this.defaultResourcesDirectory;
    }

    public File getDefaultWebappDirectory() {
        return this.defaultWebappDirectory;
    }

    public File getRebelXmlDirectory() {
        return this.rebelXmlDirectory;
    }

    public RebelMainModel getRebelModel() {
        return this.rebelModel;
    }

    public void skipWritingRebelXml() {
        this.skipWritingRebelXml = true;
    }

    public void setPluginConfigured() {
        this.isPluginConfigured = true;
    }

    @TaskAction
    public void generate() {
        if (!this.isPluginConfigured.booleanValue()) {
            throw new IllegalStateException("generateRebel is only valid when JavaPlugin is applied directly or indirectly (via other plugins that apply it implicitly, like Groovy or War); please update your build");
        }
        this.propagateConventionMappingSettings();
        this.log.info("rebel.alwaysGenerate = " + this.alwaysGenerate);
        this.log.info("rebel.showGenerated = " + this.showGenerated);
        this.log.info("rebel.rebelXmlDirectory = " + this.rebelXmlDirectory);
        this.log.info("rebel.packaging = " + this.packaging);
        this.log.info("rebel.war = " + this.war);
        this.log.info("rebel.web = " + this.web);
        this.log.info("rebel.classpath = " + this.classpath);
        this.log.info("rebel.defaultClassesDirectory = " + this.defaultClassesDirectory);
        this.log.info("rebel.defaultResourcesDirectory = " + this.defaultResourcesDirectory);
        this.log.info("rebel.defaultWebappDirectory = " + this.defaultWebappDirectory);
        this.log.info("rebel.configuredRootPath = " + this.configuredRootPath);
        this.log.info("rebel.configuredRelativePath = " + this.configuredRelativePath);
        File rebelXmlFile = null;
        if (this.rebelXmlDirectory != null) {
            rebelXmlFile = new File(this.rebelXmlDirectory, "rebel.xml");
        }
        File buildXmlFile = this.getProject().getBuildFile();
        if (!this.alwaysGenerate.booleanValue() && rebelXmlFile != null && rebelXmlFile.exists() && buildXmlFile != null && buildXmlFile.exists() && rebelXmlFile.lastModified() > buildXmlFile.lastModified()) {
            return;
        }
        if (this.getPackaging().equals(PACKAGING_TYPE_JAR)) {
            this.rebelModel = this.buildModelForJar();
        } else if (this.getPackaging().equals(PACKAGING_TYPE_WAR)) {
            this.rebelModel = this.buildModelForWar();
        }
        if (this.rebelModel != null && !this.skipWritingRebelXml) {
            this.generateRebelXml(rebelXmlFile);
        }
    }

    private RebelMainModel buildModelForJar() {
        this.log.info("Building rebel backend model for jar ..");
        RebelMainModel model = new RebelMainModel();
        this.buildClasspath(model);
        this.log.info("Backend model eventually built: " + model);
        return model;
    }

    private RebelMainModel buildModelForWar() {
        this.log.info("Building rebel backend model for war ..");
        RebelMainModel model = new RebelMainModel();
        this.buildWeb(model);
        this.buildClasspath(model);
        this.buildWar(model);
        this.log.info("Backend model eventually built: " + model);
        return model;
    }

    private void buildClasspath(RebelMainModel model) {
        if (this.classpath == null) {
            this.log.info("No custom classpath configuration found .. using the defaults");
            this.buildDefaultClasspath(model, null);
            return;
        }
        boolean addDefaultAsFirst = true;
        RebelClasspathResource defaultClasspath = null;
        for (RebelClasspathResource resource : this.classpath.getResources()) {
            if (!resource.isDefaultClasspathElement()) continue;
            addDefaultAsFirst = false;
            defaultClasspath = resource;
            break;
        }
        if (addDefaultAsFirst) {
            this.buildDefaultClasspath(model, defaultClasspath);
        }
        for (RebelClasspathResource resource : this.classpath.getResources()) {
            if (resource.isDefaultClasspathElement()) {
                this.buildDefaultClasspath(model, resource);
                continue;
            }
            resource.setDirectory(this.fixFilePath(resource.getDirectory()));
            model.addClasspathDir(resource);
        }
    }

    private void buildDefaultClasspath(RebelMainModel model, RebelClasspathResource defaultClasspath) throws BuildException {
        if (this.classpath == null || !this.classpath.isOmitDefaultResourcesDir().booleanValue()) {
            this.addDefaultResourcesDirToClasspath(model);
        }
        if (this.classpath == null || !this.classpath.isOmitDefaultClassesDir().booleanValue()) {
            this.addDefaultClassesDirToClasspath(model, defaultClasspath);
        }
    }

    private void addDefaultClassesDirToClasspath(RebelMainModel model, RebelClasspathResource defaultClasspath) {
        RebelClasspathResource classpathResource = new RebelClasspathResource();
        String fixedDefaultClassesDirectory = this.fixFilePath(this.defaultClassesDirectory);
        this.log.info("fixed default classes directory : " + fixedDefaultClassesDirectory);
        classpathResource.setDirectory(fixedDefaultClassesDirectory);
        if (!new File(fixedDefaultClassesDirectory).isDirectory()) {
            this.log.info("Not adding default classes directory as it doesn't exist or is not a directory");
            return;
        }
        if (defaultClasspath != null) {
            classpathResource.setIncludes(defaultClasspath.getIncludes());
            classpathResource.setExcludes(defaultClasspath.getExcludes());
        }
        model.addClasspathDir(classpathResource);
    }

    private void addDefaultResourcesDirToClasspath(RebelMainModel model) throws BuildException {
        this.log.info("Adding default resources directory to classpath ..");
        RebelClasspathResource resourcesClasspathResource = new RebelClasspathResource();
        String fixedDefaultResourcesDir = this.fixFilePath(this.defaultResourcesDirectory);
        this.log.info("Default resources directory after normalizing: " + fixedDefaultResourcesDir);
        resourcesClasspathResource.setDirectory(fixedDefaultResourcesDir);
        if (!new File(resourcesClasspathResource.getDirectory()).isDirectory()) {
            this.log.info("Didn't add default resources directory as it doesn't exist or is not a directory!");
            return;
        }
        model.addClasspathDir(resourcesClasspathResource);
    }

    private void buildWeb(RebelMainModel model) {
        if (this.web == null) {
            this.buildDefaultWeb(model, null);
        } else {
            List<RebelWebResource> resources;
            boolean addDefaultAsFirst = true;
            RebelWebResource defaultWeb = null;
            for (RebelWebResource resource : this.web.getResources()) {
                if (!resource.isDefaultElement()) continue;
                defaultWeb = resource;
                addDefaultAsFirst = false;
                break;
            }
            if (addDefaultAsFirst && this.web != null && !this.web.getOmitDefault().booleanValue()) {
                this.buildDefaultWeb(model, defaultWeb);
            }
            if ((resources = this.web.getResources()) != null && resources.size() > 0) {
                for (int i = 0; i < resources.size(); ++i) {
                    RebelWebResource resource = resources.get(i);
                    if (resource.isDefaultElement()) {
                        if (this.web.getOmitDefault().booleanValue()) continue;
                        this.buildDefaultWeb(model, resource);
                        continue;
                    }
                    resource.setDirectory(this.fixFilePath(resource.getDirectory()));
                    model.addWebResource(resource);
                }
            }
        }
    }

    private void buildDefaultWeb(RebelMainModel model, RebelWebResource defaultWeb) {
        RebelWebResource r = new RebelWebResource();
        r.setTarget("/");
        r.setDirectory(this.fixFilePath(this.defaultWebappDirectory));
        if (defaultWeb != null) {
            r.setIncludes(defaultWeb.getIncludes());
            r.setExcludes(defaultWeb.getExcludes());
        }
        model.addWebResource(r);
    }

    private void buildWar(RebelMainModel model) {
        if (this.war != null && this.war.getPath() != null) {
            this.war.setOriginalPath(this.war.getPath());
            this.war.setPath(this.fixFilePath(this.war.getPath()));
            model.setWar(this.war);
        }
    }

    private void generateRebelXml(File rebelXmlFile) {
        this.log.info("Processing ${project.group}:${project.name} with packaging " + this.getPackaging());
        this.log.info("Generating \"${rebelXmlFile}\"...");
        try {
            String xmlFileContents = this.getRebelModel().toXmlString();
            if (this.getShowGenerated().booleanValue()) {
                System.out.println(xmlFileContents);
            }
            rebelXmlFile.getParentFile().mkdirs();
            FileUtil.writeToFile(rebelXmlFile, xmlFileContents);
        }
        catch (IOException e) {
            throw new BuildException("Failed writing \"${rebelXmlFile}\"", (Throwable)e);
        }
    }

    private String fixFilePath(File file) {
        String relative;
        File baseDir = this.getProject().getProjectDir();
        if (file.isAbsolute() && !FileUtil.isRelativeToPath(new File(baseDir, this.getRelativePath()), file)) {
            return StringUtils.replace((String)FileUtil.getCanonicalPath(file), (String)"\\", (String)"/");
        }
        if (!file.isAbsolute()) {
            file = new File(baseDir, file.getPath());
        }
        if (!new File(relative = FileUtil.getRelativePath(new File(baseDir, this.getRelativePath()), file)).isAbsolute()) {
            return StringUtils.replace((String)this.getRootPath(), (String)"\\", (String)"/") + "/" + relative;
        }
        if (new File(this.getRootPath()).isAbsolute()) {
            String s = FileUtil.getRelativePath(new File(this.getRootPath()), file);
            if (!new File(s).isAbsolute()) {
                return StringUtils.replace((String)this.getRootPath(), (String)"\\", (String)"/") + "/" + s;
            }
            return s;
        }
        return StringUtils.replace((String)file.getAbsolutePath(), (String)"\\", (String)"/");
    }

    private String fixFilePath(String path) {
        return this.fixFilePath(new File(path));
    }

    private String getRelativePath() {
        if (this.getConfiguredRelativePath() != null) {
            return this.getConfiguredRelativePath().getAbsolutePath();
        }
        return ".";
    }

    private String getRootPath() {
        if (this.getConfiguredRootPath() != null) {
            return this.getConfiguredRootPath();
        }
        return this.getProject().getProjectDir().getAbsolutePath();
    }

    public File getDefaultClassesDirectory$MAGIC() {
        return null;
    }

    public File getDefaultResourcesDirectory$MAGIC() {
        return null;
    }

    public File getDefaultWebappDirectory$MAGIC() {
        return null;
    }

    public File getRebelXmlDirectory$MAGIC() {
        return null;
    }

    public void propagateConventionMappingSettings() {
        this.defaultClassesDirectory = this.getDefaultClassesDirectory$MAGIC();
        this.defaultResourcesDirectory = this.getDefaultResourcesDirectory$MAGIC();
        this.defaultWebappDirectory = this.getDefaultWebappDirectory$MAGIC();
        this.rebelXmlDirectory = this.getRebelXmlDirectory$MAGIC();
    }
}

