/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jrebel.gradle;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.plugins.WarPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetOutput;
import org.zeroturnaround.jrebel.gradle.RebelGenerateTask;
import org.zeroturnaround.jrebel.gradle.dsl.RebelDslClasspath;
import org.zeroturnaround.jrebel.gradle.dsl.RebelDslMain;
import org.zeroturnaround.jrebel.gradle.dsl.RebelDslWar;
import org.zeroturnaround.jrebel.gradle.dsl.RebelDslWeb;
import org.zeroturnaround.jrebel.gradle.util.BooleanUtil;
import org.zeroturnaround.jrebel.gradle.util.LoggerWrapper;

public class RebelPlugin
implements Plugin<Project> {
    public static final String GENERATE_REBEL_TASK_NAME = "generateRebel";
    public static final String REBEL_EXTENSION_NAME = "rebel";
    private LoggerWrapper log;

    public void apply(final Project project) {
        this.log = new LoggerWrapper(project.getLogger());
        ((RebelGenerateTask)project.getTasks().create(GENERATE_REBEL_TASK_NAME, RebelGenerateTask.class)).setDescription("Generate rebel.xml mappings file to use this project with JRebel.");
        project.getLogger().info("Registering deferred Rebel plugin configuration...");
        project.getPlugins().withType(JavaPlugin.class).all((Action)new Action<Plugin>(){

            public void execute(Plugin p) {
                RebelPlugin.this.configure(project);
            }
        });
    }

    private void configure(Project project) {
        this.log.info("Configuring Rebel plugin...");
        project.getExtensions().create(REBEL_EXTENSION_NAME, RebelDslMain.class, new Object[0]);
        RebelGenerateTask generateRebelTask = (RebelGenerateTask)project.getTasks().getByName(GENERATE_REBEL_TASK_NAME);
        IConventionAware conventionAwareRebelTask = (IConventionAware)generateRebelTask;
        if (project.getPlugins().hasPlugin("java")) {
            project.getTasks().getByName("processResources").dependsOn(new Object[]{generateRebelTask});
        }
        RebelDslMain rebelExtension = (RebelDslMain)project.getExtensions().getByName(REBEL_EXTENSION_NAME);
        this.configureRebelXmlDirectory(project, conventionAwareRebelTask, rebelExtension);
        generateRebelTask.setPackaging("jar");
        this.configureWarPluginSettings(project, generateRebelTask, conventionAwareRebelTask, rebelExtension);
        this.configureDefaultClassesDirectory(project, conventionAwareRebelTask);
        this.configureDefaultResourcesDirectory(project, conventionAwareRebelTask);
        this.configureProjectAfterEvaluate(project, generateRebelTask, rebelExtension);
        generateRebelTask.setPluginConfigured();
    }

    private void configureRebelXmlDirectory(final Project project, IConventionAware conventionAwareRebelTask, final RebelDslMain rebelExtension) {
        conventionAwareRebelTask.getConventionMapping().map("rebelXmlDirectory$MAGIC", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (project.hasProperty("rebel.rebelXmlDirectory")) {
                    return new File(project.property("rebel.rebelXmlDirectory").toString());
                }
                if (rebelExtension.getRebelXmlDirectory() != null) {
                    return new File(rebelExtension.getRebelXmlDirectory());
                }
                return RebelPlugin.this.getMainOutput(project).getResourcesDir();
            }
        });
    }

    private void configureWarPluginSettings(final Project project, final RebelGenerateTask generateRebelTask, final IConventionAware conventionAwareRebelTask, RebelDslMain rebelExtension) {
        project.getPlugins().withType(WarPlugin.class).all((Action)new Action<Plugin>(){

            public void execute(Plugin p) {
                generateRebelTask.setPackaging("war");
                conventionAwareRebelTask.getConventionMapping().map("defaultWebappDirectory$MAGIC", (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        try {
                            WarPluginConvention warConvention = (WarPluginConvention)project.getConvention().getPlugin(WarPluginConvention.class);
                            return warConvention.getWebAppDir();
                        }
                        catch (Exception e) {
                            return null;
                        }
                    }
                });
            }
        });
    }

    private void configureDefaultClassesDirectory(final Project project, IConventionAware conventionAwareRebelTask) {
        conventionAwareRebelTask.getConventionMapping().map("defaultClassesDirectories$MAGIC", (Callable)new Callable<List<File>>(){

            @Override
            public List<File> call() {
                try {
                    return RebelPlugin.this.getClassesDirs(RebelPlugin.this.getMainOutput(project));
                }
                catch (Exception e) {
                    return null;
                }
            }
        });
    }

    private List<File> getClassesDirs(SourceSetOutput sourceSet) {
        ArrayList<File> files = new ArrayList<File>(sourceSet.getFiles());
        files.remove(sourceSet.getResourcesDir());
        return files;
    }

    private void configureDefaultResourcesDirectory(final Project project, IConventionAware conventionAwareRebelTask) {
        conventionAwareRebelTask.getConventionMapping().map("defaultResourcesDirectory$MAGIC", (Callable)new Callable<File>(){

            @Override
            public File call() {
                try {
                    return RebelPlugin.this.getMainOutput(project).getResourcesDir();
                }
                catch (Exception e) {
                    return null;
                }
            }
        });
    }

    private SourceSetOutput getMainOutput(Project project) {
        JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
        return ((SourceSet)javaConvention.getSourceSets().getByName("main")).getOutput();
    }

    private void configureProjectAfterEvaluate(Project project, final RebelGenerateTask generateRebelTask, final RebelDslMain rebelExtension) {
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                RebelDslWeb web;
                RebelDslWar war;
                Boolean showGenerated = BooleanUtil.convertNullToFalse(rebelExtension.getShowGenerated());
                generateRebelTask.setShowGenerated(showGenerated);
                Boolean alwaysGenerate = BooleanUtil.convertNullToFalse(rebelExtension.getAlwaysGenerate());
                generateRebelTask.setAlwaysGenerate(alwaysGenerate);
                String rootPathFromProjectProperties = project.hasProperty("rebel.rootPath") ? project.property("rebel.rootPath").toString() : null;
                String rootPath = rootPathFromProjectProperties != null ? rootPathFromProjectProperties : rebelExtension.getRootPath();
                generateRebelTask.setConfiguredRootPath(rootPath);
                generateRebelTask.setConfiguredRelativePath(rebelExtension.getRelativePath());
                RebelDslClasspath classpath = rebelExtension.getClasspath();
                if (classpath != null) {
                    generateRebelTask.setClasspath(classpath.toRebelClasspath());
                }
                if ((war = rebelExtension.getWar()) != null) {
                    generateRebelTask.setWar(war.toRebelWar());
                }
                if ((web = rebelExtension.getWeb()) != null) {
                    generateRebelTask.setWeb(rebelExtension.getWeb().toRebelWeb());
                }
            }
        });
    }
}

