/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jrebel.gradle;

import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Plugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.plugins.WarPluginConvention;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.TaskAction;
import org.gradle.tooling.BuildException;
import org.zeroturnaround.jrebel.gradle.BaseRebelGenerateTask;
import org.zeroturnaround.jrebel.gradle.RebelModelBuilder;
import org.zeroturnaround.jrebel.gradle.dsl.RebelDslClasspath;
import org.zeroturnaround.jrebel.gradle.dsl.RebelDslMain;
import org.zeroturnaround.jrebel.gradle.dsl.RebelDslWar;
import org.zeroturnaround.jrebel.gradle.dsl.RebelDslWeb;
import org.zeroturnaround.jrebel.gradle.model.RebelMainModel;
import org.zeroturnaround.jrebel.gradle.model.RebelWar;
import org.zeroturnaround.jrebel.gradle.util.FileUtil;
import org.zeroturnaround.jrebel.gradle.util.LoggerWrapper;

public class IncrementalRebelGenerateTask
extends DefaultTask
implements BaseRebelGenerateTask {
    private LoggerWrapper log = new LoggerWrapper(this.getProject().getLogger());
    private RebelDslMain rebelDsl = (RebelDslMain)this.getProject().getExtensions().getByName("rebel");
    private Provider<String> configuredRootPath;
    private Provider<File> jrebelBuildDir;
    private Provider<File> defaultWebappDirectory;
    private Provider<List<File>> defaultClassesDirectory;
    private Provider<File> defaultResourcesDirectory;
    private Long alwaysGenerateTrigger;
    private boolean isPluginConfigured;
    private boolean skipWritingRebelXml;
    private RebelMainModel rebelModel;

    @Nested
    public RebelDslMain getRebelDsl() {
        return this.rebelDsl;
    }

    @Input
    @Optional
    public String getConfiguredRootPath() {
        return (String)this.configuredRootPath.getOrNull();
    }

    public void setConfiguredRootPath(Provider<String> provider) {
        this.configuredRootPath = provider;
    }

    @OutputDirectory
    public File getJRebelBuildDir() {
        return (File)this.jrebelBuildDir.get();
    }

    public void setJRebelBuildDir(Provider<File> provider) {
        this.jrebelBuildDir = provider;
    }

    @Input
    @Optional
    public File getDefaultWebappDirectory() {
        return this.defaultWebappDirectory != null ? (File)this.defaultWebappDirectory.getOrNull() : null;
    }

    public void setDefaultWebappDirectory(Provider<File> provider) {
        this.defaultWebappDirectory = provider;
    }

    @Input
    @Optional
    public List<File> getDefaultClassesDirectory() {
        return (List)this.defaultClassesDirectory.getOrNull();
    }

    public void setDefaultClassesDirectory(Provider<List<File>> provider) {
        this.defaultClassesDirectory = provider;
    }

    @Optional
    @Input
    public File getDefaultResourcesDirectory() {
        return (File)this.defaultResourcesDirectory.getOrNull();
    }

    public void setDefaultResourcesDirectory(Provider<File> provider) {
        this.defaultResourcesDirectory = provider;
    }

    @Input
    public Long getAlwaysGenerateTrigger() {
        return this.rebelDsl.getAlwaysGenerate() != false ? System.currentTimeMillis() : 0L;
    }

    @Override
    @TaskAction
    public void generate() {
        if (!this.isPluginConfigured) {
            throw new IllegalStateException("generateRebel is only valid when JavaPlugin is applied directly or indirectly (via other plugins that apply it implicitly, like Groovy or War); please update your build");
        }
        RebelDslMain rebelDsl = this.getRebelDsl();
        this.log.info("rebel.alwaysGenerate = " + rebelDsl.getAlwaysGenerate());
        this.log.info("rebel.showGenerated = " + rebelDsl.getShowGenerated());
        this.log.info("rebel.rebelXmlDirectory = " + rebelDsl.getRebelXmlDirectory());
        this.log.info("rebel.packaging = " + rebelDsl.getPackaging());
        this.log.info("rebel.war = " + rebelDsl.getWar());
        this.log.info("rebel.web = " + rebelDsl.getWeb());
        this.log.info("rebel.classpath = " + rebelDsl.getClasspath());
        this.log.info("rebel.defaultClassesDirectories = " + this.getDefaultClassesDirectory());
        this.log.info("rebel.defaultResourcesDirectory = " + this.getDefaultResourcesDirectory());
        this.log.info("rebel.defaultWebappDirectory = " + this.getDefaultWebappDirectory());
        this.log.info("rebel.configuredRootPath = " + this.getConfiguredRootPath());
        this.log.info("rebel.configuredRelativePath = " + this.getRebelDsl().getRelativePath());
        this.log.info("jrebel output dir " + this.jrebelBuildDir.getOrNull());
        RebelDslClasspath classpath = this.getRebelDsl().getClasspath();
        RebelDslWeb web = this.getRebelDsl().getWeb();
        RebelDslWar war = this.getRebelDsl().getWar();
        this.rebelModel = new RebelModelBuilder(this.getProject(), this.getRebelDsl().getPackaging(), classpath != null ? classpath.toRebelClasspath() : null, web != null ? web.toRebelWeb() : null, war != null ? war.toRebelWar() : null, this.getDefaultClassesDirectory(), this.getDefaultResourcesDirectory(), this.getDefaultWebappDirectory(), this.getConfiguredRootPath(), this.getRebelDsl().getRelativePath(), this.getProject().getProjectDir()).build();
        if (!this.skipWritingRebelXml) {
            File buildDir = (File)this.jrebelBuildDir.get();
            if (!buildDir.exists()) {
                buildDir.mkdir();
            }
            File rebelXmlFile = new File(buildDir, "rebel.xml");
            this.log.info("Processing " + this.getProject().getGroup() + ":" + this.getProject().getName() + " with packaging " + this.getRebelDsl().getPackaging());
            this.log.info("Generating \"" + rebelXmlFile.getAbsolutePath() + "\"...");
            try {
                String xmlFileContents = this.rebelModel.toXmlString();
                if (this.getRebelDsl().getShowGenerated().booleanValue()) {
                    System.out.println(xmlFileContents);
                }
                rebelXmlFile.getParentFile().mkdirs();
                FileUtil.writeToFile(rebelXmlFile, xmlFileContents);
            }
            catch (IOException e) {
                throw new BuildException("Failed writing \"${rebelXmlFile}\"", (Throwable)e);
            }
        }
    }

    public IncrementalRebelGenerateTask() {
        this.getProject().getPlugins().withType(WarPlugin.class).all((Action)new Action<Plugin>(){

            public void execute(Plugin p) {
                IncrementalRebelGenerateTask.this.getRebelDsl().setPackaging("war");
                IncrementalRebelGenerateTask.this.setDefaultWebappDirectory((Provider<File>)IncrementalRebelGenerateTask.this.getProject().provider((Callable)new Callable<File>(){

                    @Override
                    public File call() {
                        try {
                            WarPluginConvention warConvention = (WarPluginConvention)IncrementalRebelGenerateTask.this.getProject().getConvention().getPlugin(WarPluginConvention.class);
                            return warConvention.getWebAppDir();
                        }
                        catch (Exception e) {
                            return null;
                        }
                    }
                }));
            }
        });
        this.setDefaultClassesDirectory((Provider<List<File>>)this.getProject().provider((Callable)new Callable<List<File>>(){

            @Override
            public List<File> call() {
                JavaPluginConvention javaConvention = (JavaPluginConvention)IncrementalRebelGenerateTask.this.getProject().getConvention().findPlugin(JavaPluginConvention.class);
                if (javaConvention != null) {
                    SourceSetOutput main = ((SourceSet)javaConvention.getSourceSets().getByName("main")).getOutput();
                    return new ArrayList<File>(main.getClassesDirs().getFiles());
                }
                return null;
            }
        }));
        this.setDefaultResourcesDirectory((Provider<File>)this.getProject().provider((Callable)new Callable<File>(){

            @Override
            public File call() {
                JavaPluginConvention javaConvention = (JavaPluginConvention)IncrementalRebelGenerateTask.this.getProject().getConvention().findPlugin(JavaPluginConvention.class);
                if (javaConvention != null) {
                    return ((SourceSet)javaConvention.getSourceSets().getByName("main")).getOutput().getResourcesDir();
                }
                return null;
            }
        }));
        this.setConfiguredRootPath((Provider<String>)this.getProject().getProviders().provider((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                String rootPathFromProjectProperties = IncrementalRebelGenerateTask.this.getProject().hasProperty("rebel.rootPath") ? IncrementalRebelGenerateTask.this.getProject().property("rebel.rootPath").toString() : null;
                String rootPath = rootPathFromProjectProperties != null ? rootPathFromProjectProperties : IncrementalRebelGenerateTask.this.getRebelDsl().getRootPath();
                return rootPath;
            }
        }));
        final Provider jRebelBuildDir = this.getProject().provider((Callable)new Callable<File>(){

            @Override
            public File call() throws Exception {
                if (IncrementalRebelGenerateTask.this.getProject().hasProperty("rebel.rebelXmlDirectory")) {
                    return new File(IncrementalRebelGenerateTask.this.getProject().property("rebel.rebelXmlDirectory").toString());
                }
                if (IncrementalRebelGenerateTask.this.rebelDsl.getRebelXmlDirectory() != null) {
                    return new File(IncrementalRebelGenerateTask.this.getProject().getProjectDir(), IncrementalRebelGenerateTask.this.rebelDsl.getRebelXmlDirectory());
                }
                return new File(IncrementalRebelGenerateTask.this.getProject().getBuildDir(), "jrebel");
            }
        });
        Closure<File> fileClosure = new Closure<File>((Object)this){

            public File call() {
                return (File)jRebelBuildDir.getOrNull();
            }
        };
        this.setJRebelBuildDir((Provider<File>)jRebelBuildDir);
        final IncrementalRebelGenerateTask generateTask = this;
        this.getProject().getPlugins().withType(JavaPlugin.class).all((Action)new Action<Plugin>((Closure)fileClosure){
            final /* synthetic */ Closure val$fileClosure;
            {
                this.val$fileClosure = closure;
            }

            public void execute(Plugin p) {
                Copy processResourcesTask = (Copy)IncrementalRebelGenerateTask.this.getProject().getTasks().getByName("processResources");
                processResourcesTask.dependsOn(new Object[]{generateTask});
                processResourcesTask.from(new Object[]{this.val$fileClosure});
                IncrementalRebelGenerateTask.this.setPluginConfigured();
            }
        });
    }

    @Override
    public String getPackaging() {
        return this.getRebelDsl().getPackaging();
    }

    @Override
    public void skipWritingRebelXml() {
        this.skipWritingRebelXml = true;
    }

    @Override
    public RebelMainModel getRebelModel() {
        return this.rebelModel;
    }

    @Override
    public void propagateConventionMappingSettings() {
    }

    @Override
    public boolean getShowGenerated() {
        return this.getRebelDsl().getShowGenerated();
    }

    @Override
    public boolean getAlwaysGenerate() {
        return this.getRebelDsl().getAlwaysGenerate();
    }

    @Override
    public RebelWar getWar() {
        return this.rebelModel.getWar();
    }

    void setPluginConfigured() {
        this.isPluginConfigured = true;
    }
}

