/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jrebel.gradle.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.commons.lang.StringUtils;
import org.gradle.tooling.BuildException;

public class FileUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(File file, String contents) throws IOException {
        Writer w = null;
        try {
            FileOutputStream is = new FileOutputStream(file);
            OutputStreamWriter osw = new OutputStreamWriter(is);
            w = new BufferedWriter(osw);
            w.write(contents);
        }
        finally {
            w.close();
        }
    }

    public static String getCanonicalPath(File file) throws BuildException {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new BuildException("Failed to get canonical path of " + file.getAbsolutePath(), (Throwable)e);
        }
    }

    public static boolean isRelativeToPath(File baseDir, File file) throws BuildException {
        String basedirpath = FileUtil.getCanonicalPath(baseDir);
        String absolutePath = FileUtil.getCanonicalPath(file);
        return absolutePath.startsWith(basedirpath);
    }

    public static String getRelativePath(File baseDir, File file) throws BuildException {
        String basedirpath = FileUtil.getCanonicalPath(baseDir) + File.separator;
        String absolutePath = FileUtil.getCanonicalPath(file);
        String relative = absolutePath.equals(basedirpath) ? "." : (absolutePath.startsWith(basedirpath) ? absolutePath.substring(basedirpath.length()) : absolutePath);
        relative = StringUtils.replace((String)relative, (String)"\\", (String)"/");
        return relative;
    }
}

