/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jrebel.gradle;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.tooling.BuildException;
import org.gradle.util.GradleVersion;
import org.zeroturnaround.jrebel.gradle.BaseRebelGenerateTask;
import org.zeroturnaround.jrebel.gradle.RebelModelBuilder;
import org.zeroturnaround.jrebel.gradle.model.RebelClasspath;
import org.zeroturnaround.jrebel.gradle.model.RebelMainModel;
import org.zeroturnaround.jrebel.gradle.model.RebelWar;
import org.zeroturnaround.jrebel.gradle.model.RebelWeb;
import org.zeroturnaround.jrebel.gradle.util.FileUtil;
import org.zeroturnaround.jrebel.gradle.util.LoggerWrapper;

public class LegacyRebelGenerateTask
extends DefaultTask
implements BaseRebelGenerateTask {
    public static final String PACKAGING_TYPE_JAR = "jar";
    public static final String PACKAGING_TYPE_WAR = "war";
    public static final String GRADLE_PLUGIN_VERSION = LegacyRebelGenerateTask.extractVersionOfPluginFromManifest();
    public static final String GRADLE_VERSION = GradleVersion.current().getVersion();
    private LoggerWrapper log = new LoggerWrapper(this.getProject().getLogger());
    private String packaging;
    private RebelClasspath classpath;
    private RebelWeb web;
    private RebelWar war;
    private RebelMainModel rebelModel;
    private boolean skipWritingRebelXml;
    private boolean alwaysGenerate;
    private List<File> defaultClassesDirectories;
    private File defaultResourcesDirectory;
    private File defaultWebappDirectory;
    private boolean showGenerated;
    private File rebelXmlDirectory;
    private boolean isPluginConfigured;
    private String configuredRootPath;
    private File configuredRelativePath;
    private String remoteId;
    private boolean generateRebelRemote;
    public static final String NAME_DEFAULT_CLASSES_DIRECTORIES = "defaultClassesDirectories$MAGIC";
    public static final String NAME_DEFAULT_RESOURCES_DIRECTORY = "defaultResourcesDirectory$MAGIC";
    public static final String NAME_DEFAULT_WEBAPP_DIRECTORY = "defaultWebappDirectory$MAGIC";
    public static final String NAME_REBEL_XML_DIRECTORY = "rebelXmlDirectory$MAGIC";

    @Internal
    public String getConfiguredRootPath() {
        return this.configuredRootPath;
    }

    public void setConfiguredRootPath(String path) {
        this.configuredRootPath = path;
    }

    @Internal
    public File getConfiguredRelativePath() {
        return this.configuredRelativePath;
    }

    public void setConfiguredRelativePath(File path) {
        this.configuredRelativePath = path;
    }

    @Override
    public String getPackaging() {
        return this.packaging;
    }

    public void setPackaging(String packaging) {
        this.packaging = packaging;
    }

    @Override
    public boolean getShowGenerated() {
        return this.showGenerated;
    }

    public void setShowGenerated(boolean showGenerated) {
        this.showGenerated = showGenerated;
    }

    @Internal
    public RebelClasspath getClasspath() {
        return this.classpath;
    }

    public void setClasspath(RebelClasspath path) {
        this.classpath = path;
    }

    @Internal
    public RebelWeb getWeb() {
        return this.web;
    }

    public void setWeb(RebelWeb web) {
        this.web = web;
    }

    @Override
    public RebelWar getWar() {
        return this.war;
    }

    public void setWar(RebelWar _war) {
        this.war = _war;
    }

    @Override
    public boolean getAlwaysGenerate() {
        return this.alwaysGenerate;
    }

    public void setAlwaysGenerate(boolean alwaysGenerate) {
        this.alwaysGenerate = alwaysGenerate;
    }

    @Internal
    public List<File> getDefaultClassesDirectory() {
        return this.defaultClassesDirectories;
    }

    @Internal
    public File getDefaultResourcesDirectory() {
        return this.defaultResourcesDirectory;
    }

    @Internal
    public File getDefaultWebappDirectory() {
        return this.defaultWebappDirectory;
    }

    @Internal
    public File getRebelXmlDirectory() {
        return this.rebelXmlDirectory;
    }

    @Internal
    public String getRemoteId() {
        return this.remoteId;
    }

    public void setRemoteId(String remoteId) {
        this.remoteId = remoteId;
    }

    @Internal
    public boolean getGenerateRebelRemote() {
        return this.generateRebelRemote;
    }

    public void setGenerateRebelRemote(boolean generateRebelRemote) {
        this.generateRebelRemote = generateRebelRemote;
    }

    @Override
    public RebelMainModel getRebelModel() {
        return this.rebelModel;
    }

    @Override
    public void skipWritingRebelXml() {
        this.skipWritingRebelXml = true;
    }

    public void setPluginConfigured() {
        this.isPluginConfigured = true;
    }

    private File getRebelXml() {
        if (this.rebelXmlDirectory == null) {
            return null;
        }
        return new File(this.rebelXmlDirectory, "rebel.xml");
    }

    @Override
    @TaskAction
    public void generate() {
        if (!this.isPluginConfigured) {
            throw new IllegalStateException("generateRebel is only valid when JavaPlugin is applied directly or indirectly (via other plugins that apply it implicitly, like Groovy or War); please update your build");
        }
        this.propagateConventionMappingSettings();
        this.log.info("rebel.alwaysGenerate = " + this.alwaysGenerate);
        this.log.info("rebel.showGenerated = " + this.showGenerated);
        this.log.info("rebel.rebelXmlDirectory = " + this.rebelXmlDirectory);
        this.log.info("rebel.packaging = " + this.packaging);
        this.log.info("rebel.war = " + this.war);
        this.log.info("rebel.web = " + this.web);
        this.log.info("rebel.classpath = " + this.classpath);
        this.log.info("rebel.defaultClassesDirectories = " + this.defaultClassesDirectories);
        this.log.info("rebel.defaultResourcesDirectory = " + this.defaultResourcesDirectory);
        this.log.info("rebel.defaultWebappDirectory = " + this.defaultWebappDirectory);
        this.log.info("rebel.configuredRootPath = " + this.configuredRootPath);
        this.log.info("rebel.configuredRelativePath = " + this.configuredRelativePath);
        this.log.info("rebel.remoteId = " + this.remoteId);
        this.log.info("rebel.generateRebelRemote = " + this.generateRebelRemote);
        File rebelXmlFile = this.getRebelXml();
        File buildXmlFile = this.getProject().getBuildFile();
        if (!this.alwaysGenerate && rebelXmlFile != null && rebelXmlFile.exists() && buildXmlFile != null && buildXmlFile.exists() && rebelXmlFile.lastModified() > buildXmlFile.lastModified()) {
            return;
        }
        this.rebelModel = new RebelModelBuilder(this.getProject(), this.getPackaging(), this.classpath, this.web, this.war, this.defaultClassesDirectories, this.defaultResourcesDirectory, this.defaultWebappDirectory, this.configuredRootPath, this.configuredRelativePath, this.getProject().getProjectDir(), this.remoteId).build();
        if (this.rebelModel != null && !this.skipWritingRebelXml) {
            this.generateRebelXml(rebelXmlFile);
        }
    }

    private static String extractVersionOfPluginFromManifest() {
        String result = LegacyRebelGenerateTask.class.getPackage().getImplementationVersion();
        return result == null ? "Unknown" : result;
    }

    private void generateRebelXml(File rebelXmlFile) {
        this.log.info("Processing ${project.group}:${project.name} with packaging " + this.getPackaging());
        this.log.info("Generating \"${rebelXmlFile}\"...");
        try {
            String xmlFileContents = this.getRebelModel().toXmlString();
            if (this.getShowGenerated()) {
                System.out.println(xmlFileContents);
            }
            rebelXmlFile.getParentFile().mkdirs();
            FileUtil.writeToFile(rebelXmlFile, xmlFileContents);
        }
        catch (IOException e) {
            throw new BuildException("Failed writing \"${rebelXmlFile}\"", (Throwable)e);
        }
    }

    @Internal
    public List<File> getDefaultClassesDirectories$MAGIC() {
        return null;
    }

    @Internal
    public File getDefaultResourcesDirectory$MAGIC() {
        return null;
    }

    @Internal
    public File getDefaultWebappDirectory$MAGIC() {
        return null;
    }

    @Internal
    public File getRebelXmlDirectory$MAGIC() {
        return null;
    }

    @Override
    public void propagateConventionMappingSettings() {
        this.defaultClassesDirectories = this.getDefaultClassesDirectories$MAGIC();
        this.defaultResourcesDirectory = this.getDefaultResourcesDirectory$MAGIC();
        this.defaultWebappDirectory = this.getDefaultWebappDirectory$MAGIC();
        this.rebelXmlDirectory = this.getRebelXmlDirectory$MAGIC();
    }
}

