/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jrebel.gradle;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.zeroturnaround.jrebel.gradle.LegacyRebelGenerateTask;
import org.zeroturnaround.jrebel.gradle.model.RebelClasspathResource;
import org.zeroturnaround.jrebel.gradle.model.RebelMainModel;
import org.zeroturnaround.jrebel.gradle.model.RebelResource;
import org.zeroturnaround.jrebel.gradle.model.RebelWar;
import org.zeroturnaround.jrebel.gradle.model.RebelWebResource;

public class RebelXmlWriter {
    public String toXmlString(RebelMainModel model) {
        String string;
        StringWriter writer = new StringWriter();
        try {
            this.writeHeader(writer);
            this.writeId(model, writer);
            this.writeClasspath(model, writer);
            this.writeWar(model, writer);
            this.writeWeb(model, writer);
            this.writeFooter(writer);
            ((Writer)writer).flush();
            string = ((Object)writer).toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Writer)writer).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        ((Writer)writer).close();
        return string;
    }

    private void writeHeader(Writer writer) throws IOException {
        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        writer.write("\n<!--\n  This is the JRebel configuration file. It maps the running application to your IDE workspace, enabling JRebel reloading for this project.\n  Refer to https://manuals.zeroturnaround.com/jrebel/standalone/config.html for more information.\n-->\n<application generated-by=\"gradle\" build-tool-version=\"" + LegacyRebelGenerateTask.GRADLE_VERSION + "\" plugin-version=\"" + LegacyRebelGenerateTask.GRADLE_PLUGIN_VERSION + "\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.zeroturnaround.com\" xsi:schemaLocation=\"http://www.zeroturnaround.com https://update.zeroturnaround.com/jrebel/rebel-2_3.xsd\">\n");
        writer.write("\n");
    }

    private void writeId(RebelMainModel model, Writer writer) throws IOException {
        writer.write("  <id>" + model.getRemoteId() + "</id>\n");
        writer.write("\n");
    }

    private void writeClasspath(RebelMainModel model, Writer writer) throws IOException {
        writer.write("  <classpath");
        if (model.getFallbackClasspath() != null) {
            writer.write(" fallback=\"" + model.getFallbackClasspath() + "\"");
        }
        writer.write(">\n");
        for (RebelClasspathResource resource : model.getClasspathDirs()) {
            writer.write("    <dir name=\"" + StringEscapeUtils.escapeXml((String)resource.getDirectory()) + "\">\n");
            this.writeExcludeInclude(writer, resource);
            writer.write("    </dir>\n");
        }
        for (RebelClasspathResource resource : model.getClasspathJars()) {
            writer.write("    <jar name=\"" + StringEscapeUtils.escapeXml((String)resource.getJar()) + "\">\n");
            this.writeExcludeInclude(writer, resource);
            writer.write("    </jar>\n");
        }
        for (RebelClasspathResource resource : model.getClasspathJarsets()) {
            writer.write("    <jarset dir=\"" + StringEscapeUtils.escapeXml((String)resource.getJarset()) + "\">\n");
            this.writeExcludeInclude(writer, resource);
            writer.write("    </jarset>\n");
        }
        for (RebelClasspathResource resource : model.getClasspathDirsets()) {
            writer.write("    <dirset dir=\"" + StringEscapeUtils.escapeXml((String)resource.getDirset()) + "\">\n");
            this.writeExcludeInclude(writer, resource);
            writer.write("    </dirset>\n");
        }
        writer.write("  </classpath>\n");
        writer.write("\n");
    }

    private void writeWeb(RebelMainModel model, Writer writer) throws IOException {
        if (model.getWebResources().size() > 0) {
            writer.write("  <web>\n");
            for (RebelWebResource r : model.getWebResources()) {
                writer.write("    <link target=\"" + StringEscapeUtils.escapeXml((String)r.getTarget()) + "\">\n");
                writer.write("      <dir name=\"" + StringEscapeUtils.escapeXml((String)r.getDirectory()) + "\">\n");
                this.writeExcludeInclude(writer, r);
                writer.write("      </dir>\n");
                writer.write("    </link>\n");
            }
            writer.write("  </web>\n");
            writer.write("\n");
        }
    }

    private void writeWar(RebelMainModel model, Writer writer) throws IOException {
        RebelWar war = model.getWar();
        if (war != null) {
            if (war.getDir() != null) {
                writer.write("  <war dir=\"" + StringEscapeUtils.escapeXml((String)war.getDir()) + "\"/>\n");
            } else if (war.getFile() != null) {
                writer.write("  <war file=\"" + StringEscapeUtils.escapeXml((String)war.getFile()) + "\"/>\n");
            }
            writer.write("\n");
        }
    }

    private void writeFooter(Writer writer) throws IOException {
        writer.write("</application>\n");
    }

    private void writeExcludeInclude(Writer writer, RebelClasspathResource r) throws IOException {
        this.writeExcludeIncludeImpl(writer, r, 3);
    }

    private void writeExcludeInclude(Writer writer, RebelWebResource r) throws IOException {
        this.writeExcludeIncludeImpl(writer, r, 4);
    }

    private void writeExcludeIncludeImpl(Writer writer, RebelResource r, int indent) throws IOException {
        String indention = StringUtils.repeat((String)"  ", (int)indent);
        if (r.getExcludes() != null) {
            for (String exclude : r.getExcludes()) {
                writer.write(indention + "<exclude name=\"" + StringEscapeUtils.escapeXml((String)exclude) + "\"/>\n");
            }
        }
        if (r.getIncludes() != null) {
            for (String include : r.getIncludes()) {
                writer.write(indention + "<include name=\"" + StringEscapeUtils.escapeXml((String)include) + "\"/>\n");
            }
        }
    }
}

