/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jrebel.gradle.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public final class SystemUtils {
    private static final String[] DISALLOWED_PATH_NAMES = new String[]{"CON", "PRN", "AUX", "CLOCK$", "NUL", "COM1", "COM2", "COM3", "COM4", "LPT1", "LPT2", "LPT3", "LPT4", "LST", "KEYBD$", "SCREEN$", "$IDLE$", "CONFIG$"};

    private SystemUtils() {
    }

    public static String ensurePathAndURLSafeName(String source) {
        boolean disallowedName = false;
        if (source == null || source.length() == 0) {
            return "_";
        }
        for (String s : DISALLOWED_PATH_NAMES) {
            if (!s.equalsIgnoreCase(source)) continue;
            disallowedName = true;
            break;
        }
        if (disallowedName) {
            return "_" + source.replace("$", "_24") + "_";
        }
        StringBuilder builder = new StringBuilder(source.length());
        try {
            String urlEncoded = URLEncoder.encode(source, "UTF-8");
            block11: for (char ch : urlEncoded.toCharArray()) {
                switch (ch) {
                    case '%': {
                        builder.append('_');
                        continue block11;
                    }
                    case '[': {
                        builder.append("_5B");
                        continue block11;
                    }
                    case ']': {
                        builder.append("_5D");
                        continue block11;
                    }
                    case '+': {
                        builder.append("__");
                        continue block11;
                    }
                    case '~': {
                        builder.append("_7E");
                        continue block11;
                    }
                    case '*': {
                        builder.append("_2A");
                        continue block11;
                    }
                    default: {
                        builder.append(ch);
                    }
                }
            }
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("Can't find UTF-8 charset!", ex);
        }
        return builder.toString();
    }
}

