/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.maven;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.interpolation.ObjectBasedValueSource;
import org.codehaus.plexus.util.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.util.interpolation.ValueSource;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.zeroturnaround.javarebel.maven.RebelClasspath;
import org.zeroturnaround.javarebel.maven.RebelClasspathResource;
import org.zeroturnaround.javarebel.maven.RebelResource;
import org.zeroturnaround.javarebel.maven.RebelWar;
import org.zeroturnaround.javarebel.maven.RebelWeb;
import org.zeroturnaround.javarebel.maven.RebelWebResource;
import org.zeroturnaround.javarebel.maven.RebelXmlBuilder;

public class GenerateRebelMojo
extends AbstractMojo {
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
    private static final Set JAR_PACKAGING = new HashSet();
    private static final Set WAR_PACKAGING = new HashSet();
    private MavenProject project;
    private String packaging;
    private File classesDirectory;
    private File warSourceDirectory;
    private File webappDirectory;
    private RebelClasspath classpath;
    private RebelWar war;
    private RebelWeb web;
    private String rootPath;
    private String relativePath;
    private File rebelXmlDirectory;
    private boolean showGenerated;
    private boolean addResourcesDirToRebelXml;
    private boolean alwaysGenerate;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File rebelXmlFile = new File(this.rebelXmlDirectory, "rebel.xml").getAbsoluteFile();
        File pomXmlFile = this.project.getFile();
        if (!this.alwaysGenerate && rebelXmlFile.exists() && pomXmlFile.exists() && rebelXmlFile.lastModified() > pomXmlFile.lastModified()) {
            return;
        }
        this.getLog().info((CharSequence)("Processing " + this.project.getGroupId() + ":" + this.project.getArtifactId() + " with packaging " + this.packaging));
        RebelXmlBuilder builder = null;
        if (WAR_PACKAGING.contains(this.packaging)) {
            builder = this.buildWar();
        } else if (JAR_PACKAGING.contains(this.packaging)) {
            builder = this.buildJar();
        }
        if (builder != null) {
            Writer w = null;
            if (this.showGenerated) {
                try {
                    w = new StringWriter();
                    builder.writeXml(w);
                    this.getLog().info((CharSequence)w.toString());
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            try {
                this.rebelXmlDirectory.mkdirs();
                w = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(rebelXmlFile), "UTF-8"));
                builder.writeXml(w);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed writing rebel.xml", (Exception)e);
            }
            finally {
                if (w != null) {
                    try {
                        w.close();
                    }
                    catch (IOException ie) {}
                }
            }
        }
    }

    private RebelXmlBuilder buildWar() throws MojoExecutionException {
        RebelXmlBuilder builder = new RebelXmlBuilder();
        this.buildWeb(builder);
        this.buildClasspath(builder);
        if (this.war != null) {
            this.war.setPath(this.fixFilePath(this.war.getPath()));
            builder.setWar(this.war);
        }
        return builder;
    }

    private RebelXmlBuilder buildJar() throws MojoExecutionException {
        RebelXmlBuilder builder = new RebelXmlBuilder();
        this.buildClasspath(builder);
        return builder;
    }

    private void buildClasspath(RebelXmlBuilder builder) throws MojoExecutionException {
        RebelClasspathResource r;
        int i;
        RebelClasspathResource[] resources;
        boolean addDefaultAsFirst = true;
        RebelClasspathResource defaultClasspath = null;
        if (this.classpath != null && (resources = this.classpath.getResources()) != null && resources.length > 0) {
            for (i = 0; i < resources.length; ++i) {
                r = resources[i];
                if (r.isTargetSet()) continue;
                addDefaultAsFirst = false;
                defaultClasspath = r;
                break;
            }
        }
        if (addDefaultAsFirst) {
            this.buildDefaultClasspath(builder, defaultClasspath);
        }
        if (this.classpath != null) {
            builder.setFallbackClasspath(this.classpath.getFallback());
            resources = this.classpath.getResources();
            if (resources != null && resources.length > 0) {
                for (i = 0; i < resources.length; ++i) {
                    r = resources[i];
                    if (r.isTargetSet()) {
                        if (r.getDirectory() != null) {
                            r.setDirectory(this.fixFilePath(r.getDirectory()));
                            builder.addClasspathDir(r);
                        }
                        if (r.getJar() != null) {
                            r.setJar(this.fixFilePath(r.getJar()));
                            builder.addClasspathJar(r);
                        }
                        if (r.getJarset() != null) {
                            r.setJarset(this.fixFilePath(r.getJarset()));
                            builder.addClasspathJarset(r);
                        }
                        if (r.getDirset() == null) continue;
                        r.setDirset(this.fixFilePath(r.getDirset()));
                        builder.addClasspathDirset(r);
                        continue;
                    }
                    this.buildDefaultClasspath(builder, r);
                }
            }
        }
    }

    private void buildDefaultClasspath(RebelXmlBuilder builder, RebelClasspathResource defaultClasspath) throws MojoExecutionException {
        if (this.addResourcesDirToRebelXml) {
            this.buildDefaultClasspathResources(builder);
        }
        RebelClasspathResource r = new RebelClasspathResource();
        r.setDirectory(this.fixFilePath(this.classesDirectory));
        if (defaultClasspath != null) {
            r.setIncludes(defaultClasspath.getIncludes());
            r.setExcludes(defaultClasspath.getExcludes());
        }
        builder.addClasspathDir(r);
    }

    private void buildDefaultClasspathResources(RebelXmlBuilder builder) throws MojoExecutionException {
        boolean overwrite = Boolean.valueOf(GenerateRebelMojo.getPluginSetting(this.project, "org.apache.maven.plugins:maven-resources-plugin", "overwrite", "false"));
        RebelClasspathResource r = null;
        List resources = this.project.getResources();
        if (overwrite) {
            Collections.reverse(resources);
        }
        for (Resource resource : resources) {
            File dir = new File(resource.getDirectory());
            if (!dir.isAbsolute()) {
                dir = new File(this.project.getBasedir(), resource.getDirectory());
            }
            if (!dir.exists() || !dir.isDirectory()) continue;
            r = new RebelClasspathResource();
            if (resource.isFiltering() || resource.getTargetPath() != null) {
                if (!this.handleResourceAsInclude(r, resource)) continue;
                r.setDirectory(this.fixFilePath(this.classesDirectory));
                if (resource.getTargetPath() != null) {
                    this.setIncludePrefix(r.getIncludes(), resource.getTargetPath());
                }
            } else {
                r.setDirectory(this.fixFilePath(resource.getDirectory()));
                r.setExcludes(resource.getExcludes());
                r.setIncludes(resource.getIncludes());
            }
            builder.addClasspathDir(r);
        }
    }

    private void setIncludePrefix(List includes, String prefix) {
        if (!prefix.endsWith("/")) {
            prefix = prefix + "/";
        }
        for (int i = 0; i < includes.size(); ++i) {
            includes.set(i, prefix + (String)includes.get(i));
        }
    }

    private boolean handleResourceAsInclude(RebelResource rebelResouce, Resource resource) throws MojoExecutionException {
        ArrayList<String> includedFiles;
        File dir = new File(resource.getDirectory());
        if (!dir.isAbsolute()) {
            dir = new File(this.project.getBasedir(), resource.getDirectory());
        }
        if (!dir.exists() || !dir.isDirectory()) {
            return false;
        }
        resource.setDirectory(dir.getAbsolutePath());
        String[] files = this.getFilesToCopy(resource);
        if (files.length > 0) {
            includedFiles = new ArrayList<String>();
            for (int i = 0; i < files.length; ++i) {
                includedFiles.add(StringUtils.replace((String)files[i], (char)'\\', (char)'/'));
            }
        } else {
            return false;
        }
        rebelResouce.setIncludes(includedFiles);
        return true;
    }

    private String[] getFilesToCopy(Resource resource) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(resource.getDirectory());
        if (resource.getIncludes() != null && !resource.getIncludes().isEmpty()) {
            scanner.setIncludes(resource.getIncludes().toArray(new String[resource.getIncludes().size()]));
        } else {
            scanner.setIncludes(DEFAULT_INCLUDES);
        }
        if (resource.getExcludes() != null && !resource.getExcludes().isEmpty()) {
            scanner.setExcludes(resource.getExcludes().toArray(new String[resource.getExcludes().size()]));
        }
        scanner.addDefaultExcludes();
        scanner.scan();
        return scanner.getIncludedFiles();
    }

    private void buildWeb(RebelXmlBuilder builder) throws MojoExecutionException {
        RebelWebResource r;
        int i;
        RebelWebResource[] resources;
        boolean addDefaultAsFirst = true;
        RebelWebResource defaultWeb = null;
        if (this.web != null && (resources = this.web.getResources()) != null && resources.length > 0) {
            for (i = 0; i < resources.length; ++i) {
                r = resources[i];
                if (r.getDirectory() != null || r.getTarget() != null) continue;
                defaultWeb = r;
                addDefaultAsFirst = false;
                break;
            }
        }
        if (addDefaultAsFirst) {
            this.buildDefaultWeb(builder, defaultWeb);
        }
        if (this.web != null && (resources = this.web.getResources()) != null && resources.length > 0) {
            for (i = 0; i < resources.length; ++i) {
                r = resources[i];
                if (r.getDirectory() == null && r.getTarget() == null) {
                    this.buildDefaultWeb(builder, r);
                    continue;
                }
                r.setDirectory(this.fixFilePath(r.getDirectory()));
                builder.addWebresource(r);
            }
        }
    }

    private void buildDefaultWeb(RebelXmlBuilder builder, RebelWebResource defaultWeb) throws MojoExecutionException {
        Xpp3Dom warPluginConf = GenerateRebelMojo.getPluginConfigurationDom(this.project, "org.apache.maven.plugins:maven-war-plugin");
        if (warPluginConf != null) {
            Xpp3Dom wr;
            Xpp3Dom webappDirNode;
            Xpp3Dom warSourceNode = warPluginConf.getChild("warSourceDirectory");
            if (warSourceNode != null && warSourceNode.getValue() != null) {
                this.warSourceDirectory = new File(GenerateRebelMojo.getValue(this.project, warSourceNode));
            }
            if ((webappDirNode = warPluginConf.getChild("webappDirectory")) != null && webappDirNode.getValue() != null) {
                this.webappDirectory = new File(GenerateRebelMojo.getValue(this.project, webappDirNode));
            }
            if ((wr = warPluginConf.getChild("webResources")) != null) {
                List resources = this.parseWarResources(wr);
                Collections.reverse(resources);
                for (Resource resource : resources) {
                    File dir = new File(resource.getDirectory());
                    if (!dir.isAbsolute()) {
                        dir = new File(this.project.getBasedir(), resource.getDirectory());
                    }
                    if (!dir.exists() || !dir.isDirectory()) continue;
                    if (resource.getTargetPath() == null) {
                        resource.setTargetPath("/");
                    }
                    if (!resource.getTargetPath().endsWith("/")) {
                        resource.setTargetPath(resource.getTargetPath() + "/");
                    }
                    if (resource.getTargetPath().startsWith("WEB-INF/classes/")) {
                        if (!this.addResourcesDirToRebelXml) continue;
                        String target = resource.getTargetPath().substring("WEB-INF/classes/".length());
                        RebelClasspathResource rc = new RebelClasspathResource();
                        if (resource.isFiltering() || StringUtils.isNotEmpty((String)target)) {
                            if (!this.handleResourceAsInclude(rc, resource)) continue;
                            rc.setDirectory(this.fixFilePath(new File(this.webappDirectory, "WEB-INF/classes")));
                            if (StringUtils.isNotEmpty((String)target)) {
                                this.setIncludePrefix(rc.getIncludes(), target);
                            }
                        } else {
                            rc.setDirectory(this.fixFilePath(resource.getDirectory()));
                            rc.setExcludes(resource.getExcludes());
                            rc.setIncludes(resource.getIncludes());
                        }
                        builder.addClasspathDir(rc);
                        continue;
                    }
                    RebelWebResource r = new RebelWebResource();
                    r.setTarget(resource.getTargetPath());
                    if (resource.isFiltering()) {
                        r.setDirectory(this.fixFilePath(new File(this.webappDirectory, resource.getTargetPath())));
                        if (!this.handleResourceAsInclude(r, resource)) {
                            continue;
                        }
                    } else {
                        r.setDirectory(this.fixFilePath(resource.getDirectory()));
                        r.setExcludes(resource.getExcludes());
                        r.setIncludes(resource.getIncludes());
                    }
                    builder.addWebresource(r);
                }
            }
        }
        RebelWebResource r = new RebelWebResource();
        r.setTarget("/");
        r.setDirectory(this.fixFilePath(this.warSourceDirectory));
        if (defaultWeb != null) {
            r.setIncludes(defaultWeb.getIncludes());
            r.setExcludes(defaultWeb.getExcludes());
        }
        builder.addWebresource(r);
    }

    private List parseWarResources(Xpp3Dom warResourcesNode) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        Xpp3Dom[] resourceNodes = warResourcesNode.getChildren("resource");
        for (int i = 0; i < resourceNodes.length; ++i) {
            if (resourceNodes[i] == null || resourceNodes[i].getChild("directory") == null) continue;
            Resource resource = this.parseResourceNode(resourceNodes[i]);
            resources.add(resource);
        }
        return resources;
    }

    private Resource parseResourceNode(Xpp3Dom rn) {
        int i;
        Resource r = new Resource();
        if (rn.getChild("directory") != null) {
            r.setDirectory(GenerateRebelMojo.getValue(this.project, rn.getChild("directory")));
        }
        if (rn.getChild("filtering") != null) {
            r.setFiltering(new Boolean(GenerateRebelMojo.getValue(this.project, rn.getChild("filtering"))).booleanValue());
        }
        if (rn.getChild("targetPath") != null) {
            r.setTargetPath(rn.getChild("targetPath").getValue());
        }
        if (rn.getChild("excludes") != null) {
            ArrayList<String> excludes = new ArrayList<String>();
            Xpp3Dom[] excludeNodes = rn.getChild("excludes").getChildren("exclude");
            for (i = 0; i < excludeNodes.length; ++i) {
                if (excludeNodes[i] == null || excludeNodes[i].getValue() == null) continue;
                excludes.add(GenerateRebelMojo.getValue(this.project, excludeNodes[i]));
            }
            r.setExcludes(excludes);
        }
        if (rn.getChild("includes") != null) {
            ArrayList<String> includes = new ArrayList<String>();
            Xpp3Dom[] includeNodes = rn.getChild("includes").getChildren("include");
            for (i = 0; i < includeNodes.length; ++i) {
                if (includeNodes[i] == null || includeNodes[i].getValue() == null) continue;
                includes.add(GenerateRebelMojo.getValue(this.project, includeNodes[i]));
            }
            r.setIncludes(includes);
        }
        return r;
    }

    private static Xpp3Dom getPluginConfigurationDom(MavenProject project, String pluginId) {
        Plugin plugin = (Plugin)project.getBuild().getPluginsAsMap().get(pluginId);
        if (plugin != null) {
            return (Xpp3Dom)plugin.getConfiguration();
        }
        return null;
    }

    private static String getPluginSetting(MavenProject project, String pluginId, String optionName, String defaultValue) {
        Xpp3Dom dom = GenerateRebelMojo.getPluginConfigurationDom(project, pluginId);
        if (dom != null && dom.getChild(optionName) != null) {
            return GenerateRebelMojo.getValue(project, dom.getChild(optionName));
        }
        return defaultValue;
    }

    private static String getValue(MavenProject project, Xpp3Dom dom) {
        String value = dom.getValue();
        return GenerateRebelMojo.getValue(project, value);
    }

    private static String getValue(MavenProject project, String value) {
        if (value != null && value.indexOf("$") > -1) {
            return GenerateRebelMojo.getInterpolatorValue(project, value);
        }
        return value;
    }

    private static String getInterpolatorValue(MavenProject project, String value) {
        RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
        interpolator.addValueSource((ValueSource)new ObjectBasedValueSource((Object)project));
        return interpolator.interpolate(value, "project");
    }

    private String fixFilePath(String path) throws MojoExecutionException {
        return this.fixFilePath(new File(path));
    }

    private String fixFilePath(File file) throws MojoExecutionException {
        String s;
        String relative;
        File baseDir = this.project.getFile().getParentFile();
        if (file.isAbsolute() && !GenerateRebelMojo.isRelativeToPath(new File(baseDir, this.relativePath), file)) {
            return StringUtils.replace((String)GenerateRebelMojo.getCanonicalPath(file), (char)'\\', (char)'/');
        }
        if (!file.isAbsolute()) {
            file = new File(baseDir, file.getPath());
        }
        if (!new File(relative = GenerateRebelMojo.getRelativePath(new File(baseDir, this.relativePath), file)).isAbsolute()) {
            return StringUtils.replace((String)this.rootPath, (char)'\\', (char)'/') + "/" + relative;
        }
        if (new File(this.rootPath).isAbsolute() && !new File(s = GenerateRebelMojo.getRelativePath(new File(this.rootPath), file)).isAbsolute()) {
            return StringUtils.replace((String)this.rootPath, (char)'\\', (char)'/') + "/" + s;
        }
        return StringUtils.replace((String)file.getAbsolutePath(), (char)'\\', (char)'/');
    }

    private static String getRelativePath(File baseDir, File file) throws MojoExecutionException {
        String basedirpath = GenerateRebelMojo.getCanonicalPath(baseDir);
        String absolutePath = GenerateRebelMojo.getCanonicalPath(file);
        String relative = absolutePath.equals(basedirpath) ? "." : (absolutePath.startsWith(basedirpath) ? absolutePath.substring(basedirpath.length() + 1) : absolutePath);
        relative = StringUtils.replace((String)relative, (char)'\\', (char)'/');
        return relative;
    }

    private static boolean isRelativeToPath(File baseDir, File file) throws MojoExecutionException {
        String basedirpath = GenerateRebelMojo.getCanonicalPath(baseDir);
        String absolutePath = GenerateRebelMojo.getCanonicalPath(file);
        return absolutePath.startsWith(basedirpath);
    }

    private static String getCanonicalPath(File file) throws MojoExecutionException {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to get canonical path of " + file.getAbsolutePath(), (Exception)e);
        }
    }

    static {
        JAR_PACKAGING.addAll(Arrays.asList("jar", "ejb", "ejb3", "nbm", "hk2-jar", "bundle", "eclipse-plugin"));
        WAR_PACKAGING.addAll(Arrays.asList("war", "grails-app"));
    }
}

