/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.process;

import java.io.IOException;
import java.io.OutputStream;
import org.zeroturnaround.exec.InvalidExitValueException;
import org.zeroturnaround.exec.MessageLoggers;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.stream.slf4j.Slf4jStream;
import org.zeroturnaround.process.PidProcess;

public class UnixProcess
extends PidProcess {
    private static final int EXIT_CODE_NO_SUCH_PROCESS = 1;

    public UnixProcess(int pid) {
        super(pid);
    }

    @Override
    public boolean isAlive() throws IOException, InterruptedException {
        try {
            new ProcessExecutor().commandSplit(String.format("kill -0 %d", this.pid)).readOutput(true).redirectOutput((OutputStream)Slf4jStream.ofCaller().asTrace()).setMessageLogger(MessageLoggers.TRACE).exitValueNormal().executeNoTimeout();
            return true;
        }
        catch (InvalidExitValueException e) {
            if (this.isNoSuchProcess(e)) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public void destroy(boolean forceful) throws IOException, InterruptedException {
        this.kill(forceful ? "kill" : "term");
    }

    public boolean kill(String signal) throws IOException, InterruptedException {
        try {
            new ProcessExecutor().commandSplit(String.format("kill -%s %d", signal, this.pid)).redirectOutput((OutputStream)Slf4jStream.ofCaller().asDebug()).exitValueNormal().executeNoTimeout();
            return true;
        }
        catch (InvalidExitValueException e) {
            if (this.isNoSuchProcess(e)) {
                return false;
            }
            throw e;
        }
    }

    protected boolean isNoSuchProcess(InvalidExitValueException e) {
        return e.getExitValue() == 1;
    }
}

