/*
 * Decompiled with CFR 0.152.
 */
package org.zlwl.ethereum.api;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.log.Log;
import cn.hutool.log.LogFactory;
import com.google.gson.Gson;
import java.util.List;
import org.zlwl.ethereum.api.ERC20TokenTxDTO;
import org.zlwl.ethereum.api.ERC20TokenTxData;
import org.zlwl.ethereum.api.ERC721TokenTxDTO;
import org.zlwl.ethereum.api.ERC721TokenTxData;

public class Etherscan {
    public static final String URL_MAINNET = "https://api.etherscan.io/";
    public static final String URL_GOERLI = "https://api-goerli.etherscan.io/";
    public static final String URL_KOVAN = "https://api-kovan.etherscan.io/";
    public static final String URL_RINKEBY = "https://api-rinkeby.etherscan.io/";
    public static final String URL_ROPSTEN = "https://api-ropsten.etherscan.io/";
    private static final String default_api_key = "TXYWZWJHZGECS7U4TJCN1CPAXTXKSZFR74";
    private static final String STATUS_OK = "1";
    private static final String MESSAGE_NOT_FOUND = "No transactions found";
    private String baseUrl;
    private String apiKey;
    Log log = LogFactory.get();

    public Etherscan(String baseUrl, String apiKey) {
        this.baseUrl = baseUrl == null ? URL_MAINNET : baseUrl;
        this.apiKey = apiKey == null ? default_api_key : apiKey;
    }

    public List<ERC20TokenTxData> getERC20Transfers(String address) {
        String url = "api?module=account&action=tokentx&address={}&page=1&offset=10000&sort=asc";
        String response = this.httpGet(url = StrUtil.format((CharSequence)url, (Object[])new Object[]{address}));
        ERC20TokenTxDTO data = (ERC20TokenTxDTO)new Gson().fromJson(response, ERC20TokenTxDTO.class);
        if (!data.getStatus().equals(STATUS_OK) && !data.getMessage().equals(MESSAGE_NOT_FOUND)) {
            this.log.error((Throwable)new IllegalStateException(data.getMessage()));
        }
        return data.getResult();
    }

    public List<ERC721TokenTxData> getERC721Transfers(String address) {
        String url = "api?module=account&action=tokennfttx&address={}&page=1&offset=10000&sort=asc";
        String response = this.httpGet(url = StrUtil.format((CharSequence)url, (Object[])new Object[]{address}));
        ERC721TokenTxDTO data = (ERC721TokenTxDTO)new Gson().fromJson(response, ERC721TokenTxDTO.class);
        if (!data.getStatus().equals(STATUS_OK) && !data.getMessage().equals(MESSAGE_NOT_FOUND)) {
            this.log.error((Throwable)new IllegalStateException(data.getMessage()));
        }
        return data.getResult();
    }

    public String httpGet(String url) {
        url = StrUtil.format((CharSequence)"{}{}&apikey={}", (Object[])new Object[]{this.baseUrl, url, this.apiKey});
        this.log.info("url={}", new Object[]{url});
        return HttpUtil.get((String)url);
    }

    public static void main(String[] args) {
        System.setProperty("https.proxySet", "true");
        System.setProperty("https.proxyHost", "127.0.0.1");
        System.setProperty("https.proxyPort", "7890");
        Etherscan etherscan = new Etherscan(URL_RINKEBY, null);
        List<ERC20TokenTxData> erc20Transfers = etherscan.getERC20Transfers("0x4a7D597365982a941F00e11638994c17385122C9");
        List<ERC721TokenTxData> erc721Transfers = etherscan.getERC721Transfers("0x4a7D597365982a941F00e11638994c17385122C9");
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public Log getLog() {
        return this.log;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Etherscan)) {
            return false;
        }
        Etherscan other = (Etherscan)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$baseUrl = this.getBaseUrl();
        String other$baseUrl = other.getBaseUrl();
        if (this$baseUrl == null ? other$baseUrl != null : !this$baseUrl.equals(other$baseUrl)) {
            return false;
        }
        String this$apiKey = this.getApiKey();
        String other$apiKey = other.getApiKey();
        if (this$apiKey == null ? other$apiKey != null : !this$apiKey.equals(other$apiKey)) {
            return false;
        }
        Log this$log = this.getLog();
        Log other$log = other.getLog();
        return !(this$log == null ? other$log != null : !this$log.equals(other$log));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Etherscan;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $baseUrl = this.getBaseUrl();
        result = result * 59 + ($baseUrl == null ? 43 : $baseUrl.hashCode());
        String $apiKey = this.getApiKey();
        result = result * 59 + ($apiKey == null ? 43 : $apiKey.hashCode());
        Log $log = this.getLog();
        result = result * 59 + ($log == null ? 43 : $log.hashCode());
        return result;
    }

    public String toString() {
        return "Etherscan(baseUrl=" + this.getBaseUrl() + ", apiKey=" + this.getApiKey() + ", log=" + this.getLog() + ")";
    }
}

