/*
 * Decompiled with CFR 0.152.
 */
package org.zlwl.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;

public class OCRTool {
    private final String LANG_OPTION = "-l";
    private final String EOL = System.lineSeparator();
    private final String tessPath = "D://Program Files//Tesseract-OCR";

    public String recognizeText(File imageFile) throws Exception {
        BufferedReader in;
        File outputFile = new File(imageFile.getParentFile(), "output");
        StringBuffer strB = new StringBuffer();
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("D://Program Files//Tesseract-OCR\\tesseract");
        cmd.add("");
        cmd.add(outputFile.getName());
        cmd.add("-l");
        cmd.add("chi_sim+eng");
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.directory(imageFile.getParentFile());
        cmd.set(1, imageFile.getName());
        pb.command(cmd);
        pb.redirectErrorStream(true);
        long startTime = System.currentTimeMillis();
        System.out.println("\u5f00\u59cb\u65f6\u95f4\uff1a" + startTime);
        Process process = pb.start();
        int w = process.waitFor();
        if (w == 0) {
            String str;
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(outputFile.getAbsolutePath() + ".txt"), StandardCharsets.UTF_8));
            while ((str = in.readLine()) != null) {
                strB.append(str).append("\n");
            }
        } else {
            String msg = switch (w) {
                case 1 -> "Errors accessing files. There may be spaces in your image's filename.";
                case 29 -> "Cannot recognize the image or its selected region.";
                case 31 -> "Unsupported image format.";
                default -> "Errors occurred.";
            };
            throw new RuntimeException(msg);
        }
        in.close();
        long endTime = System.currentTimeMillis();
        System.out.println("\u7ed3\u675f\u65f6\u95f4\uff1a" + endTime);
        System.out.println("\u8017\u65f6\uff1a" + (endTime - startTime) + "\u6beb\u79d2");
        new File(outputFile.getAbsolutePath() + ".txt").delete();
        return strB.toString();
    }
}

