/*
 * Decompiled with CFR 0.152.
 */
package org.zlwl.wallet;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.ExecutionException;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.admin.Admin;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.methods.response.EthGasPrice;
import org.web3j.protocol.core.methods.response.EthGetBalance;
import org.web3j.protocol.core.methods.response.EthGetTransactionCount;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.protocol.http.HttpService;
import org.web3j.tx.Transfer;
import org.web3j.utils.Convert;
import org.zlwl.util.DecimalTool;

public class EthTool {
    private static final Admin admin = Admin.build((Web3jService)new HttpService("https://mainnet.infura.io/v3/4d30f4bbd2dd43938b80d8418607c2e6"));
    private static final BigDecimal decimal = new BigDecimal("1000000000000000000");

    public static BigDecimal getEthBalance(String address, int decimals) throws IOException {
        BigInteger balance = ((EthGetBalance)admin.ethGetBalance(address, (DefaultBlockParameter)DefaultBlockParameterName.LATEST).send()).getBalance();
        return new BigDecimal(balance).divide(DecimalTool.tenPow((Integer)decimals));
    }

    public static TransactionReceipt ethSend(Credentials credentials, Web3j client, String toAddress, BigDecimal amount) throws Exception {
        return (TransactionReceipt)Transfer.sendFunds((Web3j)client, (Credentials)credentials, (String)toAddress, (BigDecimal)amount, (Convert.Unit)Convert.Unit.ETHER).send();
    }

    public static BigInteger getNonce(String address, Web3j web3j) throws IOException {
        EthGetTransactionCount ethGetTransactionCount = (EthGetTransactionCount)web3j.ethGetTransactionCount(address, (DefaultBlockParameter)DefaultBlockParameterName.PENDING).send();
        if (ethGetTransactionCount == null) {
            throw new RuntimeException("failed to get nonce!");
        }
        return ethGetTransactionCount.getTransactionCount();
    }

    public static BigInteger getGesPrice(Web3j web3j) throws ExecutionException, InterruptedException {
        EthGasPrice ethGasPrice = (EthGasPrice)web3j.ethGasPrice().sendAsync().get();
        if (ethGasPrice == null) {
            throw new RuntimeException("failed to get gas price!");
        }
        return ethGasPrice.getGasPrice();
    }

    public String toDecimal(int decimal, BigInteger integer) {
        StringBuffer sbf = new StringBuffer("1");
        for (int i = 0; i < decimal; ++i) {
            sbf.append("0");
        }
        String balance = new BigDecimal(integer).divide(new BigDecimal(sbf.toString())).toPlainString();
        return balance;
    }

    public static void main(String[] args) {
        String add = "0x7339917906EcB9e5f7F6A2009e70bBEa7B0C1d43";
        try {
            BigInteger gasPrice1 = ((EthGasPrice)admin.ethGasPrice().send()).getGasPrice();
            System.out.println(gasPrice1);
            BigInteger balance = ((EthGetBalance)admin.ethGetBalance(add, (DefaultBlockParameter)DefaultBlockParameterName.LATEST).send()).getBalance();
            System.out.println(balance);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        BigDecimal ethBalance = null;
        try {
            ethBalance = EthTool.getEthBalance(add, 18);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(ethBalance);
    }
}

