/*
 * Decompiled with CFR 0.152.
 */
package org.zlwl.wallet.util;

import org.web3j.crypto.Credentials;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Keys;

public class EthAccount {
    private String address;
    private ECKeyPair keyPair;

    public EthAccount(ECKeyPair keyPair) {
        this.keyPair = keyPair;
        this.address = Keys.getAddress((ECKeyPair)keyPair);
    }

    public String getPrivateKey() {
        return this.keyPair.getPrivateKey().toString(16);
    }

    public String getPublicKey() {
        return this.keyPair.getPublicKey().toString(16);
    }

    public String get0xAddress() {
        return "0x" + this.address;
    }

    public Credentials getCredentials() {
        return Credentials.create((ECKeyPair)this.keyPair);
    }

    public String getAddress() {
        return this.address;
    }

    public ECKeyPair getKeyPair() {
        return this.keyPair;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setKeyPair(ECKeyPair keyPair) {
        this.keyPair = keyPair;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EthAccount)) {
            return false;
        }
        EthAccount other = (EthAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        ECKeyPair this$keyPair = this.getKeyPair();
        ECKeyPair other$keyPair = other.getKeyPair();
        return !(this$keyPair == null ? other$keyPair != null : !this$keyPair.equals(other$keyPair));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EthAccount;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        ECKeyPair $keyPair = this.getKeyPair();
        result = result * 59 + ($keyPair == null ? 43 : $keyPair.hashCode());
        return result;
    }

    public String toString() {
        return "EthAccount(address=" + this.getAddress() + ", keyPair=" + this.getKeyPair() + ")";
    }
}

