/*
 * Decompiled with CFR 0.152.
 */
package rest;

import core.ZOSConnection;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import rest.Response;
import rest.ZoweRequest;
import rest.ZoweRequestType;
import utility.Util;
import utility.UtilRest;

public class JsonDeleteRequest
extends ZoweRequest {
    private static final Logger LOG = LogManager.getLogger(JsonDeleteRequest.class);
    private HttpDelete request;
    private Map<String, String> additionalHeaders = new HashMap<String, String>();

    public JsonDeleteRequest(ZOSConnection connection, String url) throws Exception {
        super(connection, ZoweRequestType.VerbType.DELETE_JSON);
        this.request = new HttpDelete(Optional.ofNullable(url).orElseThrow(() -> new Exception("url not specified")));
        this.setup();
    }

    @Override
    public Response executeHttpRequest() throws Exception {
        this.additionalHeaders.forEach((key, value) -> this.request.setHeader((String)key, (String)value));
        try {
            this.httpResponse = this.client.execute((HttpUriRequest)this.request, this.localContext);
        }
        catch (IOException e) {
            e.printStackTrace();
            return new Response(Optional.empty(), Optional.empty());
        }
        int statusCode = this.httpResponse.getStatusLine().getStatusCode();
        LOG.debug("JsonDeleteRequest::httpDelete - Response statusCode {}, Response {}", (Object)this.httpResponse.getStatusLine().getStatusCode(), (Object)this.httpResponse.toString());
        if (UtilRest.isHttpError(statusCode)) {
            return new Response(Optional.ofNullable(this.httpResponse.getStatusLine().getReasonPhrase()), Optional.ofNullable(statusCode));
        }
        return new Response(UtilRest.getJsonResponseEntity(this.httpResponse), Optional.ofNullable(statusCode));
    }

    @Override
    public void setStandardHeaders() {
        this.request.setHeader("Authorization", "Basic " + Util.getAuthEncoding(this.connection));
        this.request.setHeader("Content-Type", "application/json");
        this.request.setHeader(X_CSRF_ZOSMF_HEADER_KEY, X_CSRF_ZOSMF_HEADER_VALUE);
    }

    @Override
    public void setAdditionalHeaders(Map<String, String> additionalHeaders) {
        this.additionalHeaders = additionalHeaders;
    }

    @Override
    public void setRequest(String url) throws Exception {
        this.request = new HttpDelete(Optional.ofNullable(url).orElseThrow(() -> new Exception("url not specified")));
        this.setup();
    }
}

