/*
 * Decompiled with CFR 0.152.
 */
package utility;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import utility.Util;

public class UtilIO {
    public static String FILE_DELIM = "/";
    public static String UTF8 = "utf8";
    public static String OS_WIN32 = "win32";
    public static String OS_MAC = "darwin";
    public static String OS_LINUX = "linux";

    public static Boolean isDir(String dirOrFile) {
        Util.checkNullParameter(dirOrFile == null, "dirOrFile is null");
        Util.checkStateParameter(dirOrFile == "", "dirOrFile is empty");
        Path path = Paths.get(dirOrFile, new String[0]);
        Boolean stat = Files.isDirectory(path, new LinkOption[0]);
        return stat;
    }

    public static String normalizeExtension(String extension) {
        Util.checkNullParameter(extension == null, "dirOrFile is null");
        Util.checkStateParameter(((String)extension).isEmpty() || ((String)extension).isEmpty(), "dirOrFile is empty");
        extension = ((String)extension).trim();
        if (extension != null && ((String)extension).length() > 0 && ((String)extension).substring(0, 1) != ".") {
            extension = "." + (String)extension;
        }
        return extension;
    }

    public static Boolean existsSync(String file) {
        Util.checkNullParameter(file == null, "dirOrFile is null");
        Util.checkStateParameter(file.isEmpty() || file.isEmpty(), "dirOrFile is empty");
        return Files.exists(Paths.get(file, new String[0]), new LinkOption[0]);
    }

    public static void createDirSync(String dir) throws IOException {
        Util.checkNullParameter(dir == null, "dirOrFile is null");
        Util.checkStateParameter(dir.isEmpty() || dir.isEmpty(), "dirOrFile is empty");
        if (!UtilIO.existsSync(dir).booleanValue()) {
            Path dirs = Paths.get(System.getProperty("user.dir") + dir, new String[0]);
            Files.createDirectory(dirs, new FileAttribute[0]);
        }
    }

    public static void createDirsSync(String dir) throws IOException {
        Util.checkNullParameter(dir == null, "dirOrFile is null");
        Util.checkStateParameter(dir.isEmpty() || dir.isEmpty(), "dirOrFile is empty");
        Path dirs = Paths.get(dir, new String[0]);
        Files.createDirectories(dirs, new FileAttribute[0]);
    }

    public static void createDirsSyncFromFilePath(String filePath) throws IOException {
        Util.checkNullParameter(filePath == null, "dirOrFile is null");
        Util.checkStateParameter(filePath.isEmpty() || filePath.isEmpty(), "dirOrFile is empty");
        UtilIO.createDirsSync(filePath);
    }

    public static void createSymlinkToDir(String newSymLinkPath, String existingDirPath) throws Exception {
        try {
            if (!UtilIO.existsSync(newSymLinkPath).booleanValue()) {
                Files.createSymbolicLink(Paths.get(existingDirPath, new String[0]), Paths.get(newSymLinkPath, new String[0]), new FileAttribute[0]);
                return;
            }
            if (Files.isSymbolicLink(Paths.get(newSymLinkPath, new String[0]))) {
                Files.delete(Paths.get(newSymLinkPath, new String[0]));
                Files.createSymbolicLink(Paths.get(existingDirPath, new String[0]), Paths.get(newSymLinkPath, new String[0]), new FileAttribute[0]);
                return;
            }
        }
        catch (Exception exception) {
            throw new Exception("Failed to create symbolic link from '" + newSymLinkPath + "' to '" + existingDirPath + "'\nReason: " + exception.getCause() + "\nFull exception: " + exception);
        }
        throw new Exception("The intended symlink '" + newSymLinkPath + "' already exists and is not a symbolic link. So, we did not create a symlink from there to '" + existingDirPath + "'.");
    }

    public static void mkdirp(String dir) throws IOException {
        Util.checkNullParameter(dir == null, "dirOrFile is null");
        Util.checkStateParameter(dir.isEmpty() || dir.isEmpty(), "dirOrFile is empty");
        Files.createDirectories(Paths.get(dir, new String[0]), new FileAttribute[0]);
    }

    public static BufferedReader readFileSyncBinary(String file) throws IOException {
        Util.checkNullParameter(file == null, "dirOrFile is null");
        Util.checkStateParameter(file.isEmpty() || file.isEmpty(), "dirOrFile is empty");
        return Files.newBufferedReader(Paths.get(file, new String[0]));
    }

    public static String readFileSyncAsString(String file, Boolean normalizeNewLines) {
        Util.checkNullParameter(file == null, "dirOrFile is null");
        Util.checkStateParameter(file.isEmpty() || file.isEmpty(), "dirOrFile is empty");
        if (normalizeNewLines == null) {
            normalizeNewLines = false;
        }
        InputStreamReader isr = new InputStreamReader((InputStream)((Object)Paths.get(file, new String[0])), StandardCharsets.UTF_8);
        BufferedReader content = new BufferedReader(isr);
        if (normalizeNewLines.booleanValue()) {
            return content.toString().replace("\r\n", "\n");
        }
        return content.toString();
    }

    public static String createReadStream(String file) throws IOException {
        Util.checkNullParameter(file == null, "dirOrFile is null");
        Util.checkStateParameter(file.isEmpty() || file.isEmpty(), "dirOrFile is empty");
        StringBuilder sb = new StringBuilder();
        BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)((Object)Paths.get(file, new String[0]))), 1024);
        String line = r.readLine();
        while (line != null) {
            sb.append(line);
            line = r.readLine();
        }
        return sb.toString();
    }

    public static FileOutputStream createWriteStream(String file) throws FileNotFoundException {
        Util.checkNullParameter(file == null, "dirOrFile is null");
        Util.checkStateParameter(file.isEmpty() || file.isEmpty(), "dirOrFile is empty");
        FileOutputStream output = new FileOutputStream(file);
        return output;
    }

    public static String processNewlines(String original) {
        Util.checkNullParameter(original == null, "dirOrFile is null");
        Util.checkStateParameter(original.isEmpty() || original.isEmpty(), "dirOrFile is empty");
        String OS = System.getProperty("os.name").toLowerCase();
        return original;
    }

    public static String getDefaultTextEditor() {
        String OS = System.getProperty("os.name").toLowerCase();
        if (OS.indexOf("win") >= 0) {
            return "notepad";
        }
        if (OS.indexOf("mac") >= 0) {
            return "open -a TextEdit";
        }
        return "gedit";
    }
}

