/*
 * Decompiled with CFR 0.152.
 */
package utility;

import java.util.Optional;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import rest.Response;

public class UtilRest {
    private static final Logger LOG = LogManager.getLogger(UtilRest.class);

    public static Optional<Object> getJsonResponseEntity(HttpResponse httpResponse) throws Exception {
        HttpEntity entity = httpResponse.getEntity();
        if (entity != null) {
            String result = EntityUtils.toString(entity);
            LOG.debug("UtilRest::getJsonResponseEntity - result = {}", (Object)result);
            JSONParser parser = new JSONParser();
            try {
                if (result.isEmpty()) {
                    return Optional.empty();
                }
                return Optional.ofNullable(parser.parse(result));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return Optional.empty();
    }

    public static Optional<Object> getTextResponseEntity(HttpResponse httpResponse) throws Exception {
        HttpEntity entity = httpResponse.getEntity();
        if (entity != null) {
            String result = EntityUtils.toString(entity);
            LOG.debug("UtilRest::getTextResponseEntity - result = {}", (Object)result);
            return Optional.ofNullable(result);
        }
        return Optional.empty();
    }

    public static void checkHttpErrors(Response response) throws Exception {
        if (!response.getStatusCode().isPresent()) {
            throw new Exception("no http code value returned");
        }
        int httpCode = response.getStatusCode().get();
        if (UtilRest.isHttpError(httpCode)) {
            String responsePhrase = "";
            if (response.getResponsePhrase().isPresent()) {
                responsePhrase = (String)response.getResponsePhrase().get();
            }
            Object errorMsg = "http error code ";
            errorMsg = !responsePhrase.isEmpty() ? (String)errorMsg + httpCode + " " + responsePhrase + "." : (String)errorMsg + httpCode + ".";
            throw new Exception((String)errorMsg);
        }
    }

    public static boolean isHttpError(int statusCode) {
        return !(statusCode >= 200 && statusCode <= 299 || statusCode >= 100 && statusCode <= 199);
    }
}

