/*
 * Decompiled with CFR 0.152.
 */
package utility;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import rest.ZosmfHeaders;
import utility.UtilIO;
import zosfiles.input.DownloadParams;

public class UtilZosFiles {
    public static final String DSN_SEP = ".";
    public static final String DEFAULT_FILE_EXTENSION = "txt";
    public static final Integer MAX_MEMBER_LENGTH = 8;

    public static String getDirsFromDataSet(String dataSet) {
        String regex = "\\\\$\\{this.DSN_SEP\\}";
        String string = "";
        Pattern pattern = Pattern.compile("\\\\$\\{this.DSN_SEP\\}");
        Matcher matcher = pattern.matcher("");
        String localDirectory = dataSet.replace(matcher.group(0), UtilIO.FILE_DELIM).toLowerCase(Locale.ROOT);
        if (localDirectory.indexOf("(") >= 0 && localDirectory.indexOf(")") >= 0) {
            localDirectory = localDirectory.replace("(", UtilIO.FILE_DELIM);
            localDirectory = localDirectory.substring(0, -1);
        }
        return localDirectory;
    }

    public static Map<String, String> generateHeadersBasedOnOptions(DownloadParams options) {
        Object value;
        String key;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (options.getBinary().isPresent()) {
            key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_BINARY").get(0);
            value = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_BINARY").get(1);
            headers.put(key, (String)value);
        } else if (options.getEncoding().isPresent()) {
            key = "X_IBM_TEXT";
            value = "X_IBM_TEXTX_IBM_TEXT_ENCODING" + options.getEncoding();
            headers.put(key, (String)value);
        }
        key = (String)ZosmfHeaders.HEADERS.get((Object)"ACCEPT_ENCODING").get(0);
        value = (String)ZosmfHeaders.HEADERS.get((Object)"ACCEPT_ENCODING").get(1);
        headers.put(key, (String)value);
        if (options.getResponseTimeout().isPresent()) {
            key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_RESPONSE_TIMEOUT").get(0);
            value = (String)ZosmfHeaders.HEADERS.get((Object)options.getResponseTimeout().toString()).get(1);
            headers.put(key, (String)value);
        }
        return headers;
    }
}

