/*
 * Decompiled with CFR 0.152.
 */
package zosconsole;

import core.ZOSConnection;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.simple.JSONObject;
import rest.Response;
import rest.ZoweRequest;
import rest.ZoweRequestFactory;
import rest.ZoweRequestType;
import utility.Util;
import utility.UtilConsole;
import utility.UtilRest;
import zosconsole.ConsoleResponse;
import zosconsole.zosmf.IssueParms;
import zosconsole.zosmf.ZosmfIssueParms;
import zosconsole.zosmf.ZosmfIssueResponse;

public class IssueCommand {
    private static final Logger LOG = LogManager.getLogger(IssueCommand.class);
    private ZOSConnection connection;

    public IssueCommand(ZOSConnection connection) {
        this.connection = connection;
    }

    public ZosmfIssueResponse issueCommon(String consoleName, ZosmfIssueParms commandParms) throws Exception {
        Util.checkConnection(this.connection);
        Util.checkNullParameter(consoleName == null, "consoleName is null");
        Util.checkNullParameter(commandParms == null, "commandParms is null");
        Util.checkStateParameter(consoleName.isEmpty(), "consoleName not specified");
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getPort() + "/zosmf/restconsoles/consoles/" + consoleName;
        LOG.debug(url);
        JSONObject reqBody = new JSONObject();
        reqBody.put("cmd", commandParms.getCmd().get());
        LOG.debug(reqBody);
        ZoweRequest request = ZoweRequestFactory.buildRequest(this.connection, url, reqBody.toString(), ZoweRequestType.VerbType.PUT_JSON);
        Response response = request.executeHttpRequest();
        if (response.isEmpty()) {
            return new ZosmfIssueResponse();
        }
        UtilRest.checkHttpErrors(response);
        LOG.debug("Response result {}", (Object)response.getResponsePhrase());
        ZosmfIssueResponse zosmfIssueResponse = new ZosmfIssueResponse();
        JSONObject result = (JSONObject)response.getResponsePhrase().orElseThrow(Exception::new);
        zosmfIssueResponse.setCmdResponseKey((String)result.get("cmd-response-key"));
        zosmfIssueResponse.setCmdResponseUrl((String)result.get("cmd-response-url"));
        zosmfIssueResponse.setCmdResponseUri((String)result.get("cmd-response-uri"));
        zosmfIssueResponse.setCmdResponse((String)result.get("cmd-response"));
        zosmfIssueResponse.setSolKeyDetected((String)result.get("sol-key-detected"));
        return zosmfIssueResponse;
    }

    public ZosmfIssueResponse issueDefConsoleCommon(ZosmfIssueParms commandParms) throws Exception {
        ZosmfIssueResponse resp = this.issueCommon("defcn", commandParms);
        resp.setCmdResponse(StringEscapeUtils.escapeJava(resp.getCmdResponse().get()));
        return resp;
    }

    public ConsoleResponse issue(IssueParms parms) throws Exception {
        Util.checkNullParameter(parms == null, "parms is null");
        String consoleName = parms.getConsoleName().isPresent() ? parms.getConsoleName().get() : "defcn";
        ZosmfIssueParms commandParms = this.buildZosmfConsoleApiParameters(parms);
        ConsoleResponse response = new ConsoleResponse();
        ZosmfIssueResponse resp = this.issueCommon(consoleName, commandParms);
        response = UtilConsole.populate(resp, response, parms.getProcessResponses().isPresent() ? parms.getProcessResponses().get() : true);
        return response;
    }

    public ConsoleResponse issueSimple(String theCommand) throws Exception {
        IssueParms parms = new IssueParms();
        parms.setCommand(theCommand);
        return this.issue(parms);
    }

    public ZosmfIssueParms buildZosmfConsoleApiParameters(IssueParms parms) throws Exception {
        Util.checkNullParameter(parms == null, "parms is null");
        ZosmfIssueParms zosmfParms = new ZosmfIssueParms();
        if (!parms.getCommand().isPresent()) {
            throw new Exception("command not specified");
        }
        zosmfParms.setCmd(parms.getCommand().get());
        if (parms.getSolicitedKeyword().isPresent()) {
            zosmfParms.setSolKey(parms.getSolicitedKeyword().get());
        }
        if (parms.getSysplexSystem().isPresent()) {
            zosmfParms.setSystem(parms.getSysplexSystem().get());
        }
        return zosmfParms;
    }
}

