/*
 * Decompiled with CFR 0.152.
 */
package zosfiles;

import core.ZOSConnection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.simple.JSONObject;
import rest.Response;
import rest.ZoweRequest;
import rest.ZoweRequestFactory;
import rest.ZoweRequestType;
import utility.Util;
import utility.UtilDataset;
import utility.UtilRest;
import zosfiles.input.CreateParams;

public class ZosDsn {
    private static final Logger LOG = LogManager.getLogger(ZosDsn.class);
    private final ZOSConnection connection;

    public ZosDsn(ZOSConnection connection) {
        this.connection = connection;
    }

    public void writeDsn(String dataSetName, String content) {
        Util.checkNullParameter(dataSetName == null, "dataSetName is null");
        Util.checkStateParameter(dataSetName.isEmpty(), "dataSetName is empty");
        Util.checkConnection(this.connection);
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getPort() + "/zosmf/restfiles/ds/" + dataSetName;
        try {
            LOG.debug(url);
            ZoweRequest request = ZoweRequestFactory.buildRequest(this.connection, url, content, ZoweRequestType.VerbType.PUT_TEXT);
            Response response = request.executeHttpRequest();
            if (response.isEmpty()) {
                return;
            }
            try {
                UtilRest.checkHttpErrors(response);
            }
            catch (Exception e) {
                UtilDataset.checkHttpErrors(e.getMessage(), dataSetName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteDsn(String dataSetName) {
        Util.checkNullParameter(dataSetName == null, "dataSetName is null");
        Util.checkStateParameter(dataSetName.isEmpty(), "dataSetName is empty");
        Util.checkConnection(this.connection);
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getPort() + "/zosmf/restfiles/ds/" + dataSetName;
        try {
            LOG.debug(url);
            ZoweRequest request = ZoweRequestFactory.buildRequest(this.connection, url, null, ZoweRequestType.VerbType.DELETE_JSON);
            Response response = request.executeHttpRequest();
            if (response.isEmpty()) {
                return;
            }
            try {
                UtilRest.checkHttpErrors(response);
            }
            catch (Exception e) {
                UtilDataset.checkHttpErrors(e.getMessage(), dataSetName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createDsn(String dataSetName, CreateParams params) {
        Util.checkNullParameter(dataSetName == null, "dataSetName is null");
        Util.checkStateParameter(dataSetName.isEmpty(), "dataSetName is empty");
        Util.checkConnection(this.connection);
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getPort() + "/zosmf/restfiles/ds/" + dataSetName;
        try {
            LOG.debug(url);
            String body = ZosDsn.buildBody(params);
            ZoweRequest request = ZoweRequestFactory.buildRequest(this.connection, url, body, ZoweRequestType.VerbType.POST_JSON);
            Response response = request.executeHttpRequest();
            if (response.isEmpty()) {
                return;
            }
            try {
                UtilRest.checkHttpErrors(response);
            }
            catch (Exception e) {
                UtilDataset.checkHttpErrors(e.getMessage(), dataSetName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String buildBody(CreateParams params) {
        JSONObject reqBody = new JSONObject();
        params.getVolser().ifPresent(v -> reqBody.put("volser", v));
        params.getUnit().ifPresent(v -> reqBody.put("unit", v));
        params.getDsorg().ifPresent(v -> reqBody.put("dsorg", v));
        params.getAlcunit().ifPresent(v -> reqBody.put("alcunit", v));
        params.getPrimary().ifPresent(v -> reqBody.put("primary", v));
        params.getSecondary().ifPresent(v -> reqBody.put("secondary", v));
        params.getDirblk().ifPresent(v -> reqBody.put("dirblk", v));
        params.getAvgblk().ifPresent(v -> reqBody.put("avgblk", v));
        params.getRecfm().ifPresent(v -> reqBody.put("recfm", v));
        params.getBlksize().ifPresent(v -> reqBody.put("blksize", v));
        params.getLrecl().ifPresent(v -> reqBody.put("lrecl", v));
        params.getStorclass().ifPresent(v -> reqBody.put("storclass", v));
        params.getStorclass().ifPresent(v -> reqBody.put("mgntclass", v));
        params.getMgntclass().ifPresent(v -> reqBody.put("mgntclass", v));
        params.getDataclass().ifPresent(v -> reqBody.put("dataclass", v));
        params.getDsntype().ifPresent(v -> reqBody.put("dsntype", v));
        LOG.debug(reqBody);
        return reqBody.toString();
    }
}

