/*
 * Decompiled with CFR 0.152.
 */
package zosfiles;

import core.ZOSConnection;
import java.io.InputStream;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import rest.Response;
import rest.ZosmfHeaders;
import rest.ZoweRequest;
import rest.ZoweRequestFactory;
import rest.ZoweRequestType;
import utility.Util;
import utility.UtilDataset;
import utility.UtilRest;
import utility.UtilZosFiles;
import zosfiles.input.DownloadParams;

public class ZosDsnDownload {
    private static final Logger LOG = LogManager.getLogger(ZosDsnDownload.class);
    private final ZOSConnection connection;

    public ZosDsnDownload(ZOSConnection connection) {
        this.connection = connection;
    }

    public InputStream downloadDsn(String dataSetName, DownloadParams options) {
        Util.checkNullParameter(dataSetName == null, "dataSetName is null");
        Util.checkStateParameter(dataSetName.isEmpty(), "dataSetName is empty");
        Util.checkConnection(this.connection);
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getPort() + "/zosmf/restfiles/ds/";
        try {
            if (options.getVolume().isPresent()) {
                url = url + options.getVolume().get();
            }
            url = url + dataSetName;
            LOG.debug(url);
            Map<String, String> headers = UtilZosFiles.generateHeadersBasedOnOptions(options);
            if (options.getReturnEtag().isPresent()) {
                String key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_RETURN_ETAG").get(0);
                String value = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_RETURN_ETAG").get(1);
                headers.put(key, value);
            }
            ZoweRequest request = ZoweRequestFactory.buildRequest(this.connection, url, null, ZoweRequestType.VerbType.GET_STREAM);
            request.setAdditionalHeaders(headers);
            Response response = request.executeHttpRequest();
            if (response.isEmpty()) {
                return null;
            }
            try {
                UtilRest.checkHttpErrors(response);
            }
            catch (Exception e) {
                UtilDataset.checkHttpErrors(e.getMessage(), dataSetName);
            }
            if (response.getResponsePhrase().isPresent()) {
                return (InputStream)response.getResponsePhrase().get();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

