/*
 * Decompiled with CFR 0.152.
 */
package zosfiles;

import core.ZOSConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import rest.Response;
import rest.ZosmfHeaders;
import rest.ZoweRequest;
import rest.ZoweRequestFactory;
import rest.ZoweRequestType;
import utility.Util;
import utility.UtilDataset;
import utility.UtilRest;
import zosfiles.input.ListParams;
import zosfiles.response.Dataset;

public class ZosDsnList {
    private static final Logger LOG = LogManager.getLogger(ZosDsnList.class);

    public static List<String> listMembers(ZOSConnection connection, String dataSetName, ListParams options) {
        Util.checkNullParameter(dataSetName == null, "dataSetName is null");
        Util.checkStateParameter(dataSetName.isEmpty(), "dataSetName is empty");
        Util.checkConnection(connection);
        HashMap<String, String> headers = new HashMap<String, String>();
        ArrayList<String> members = new ArrayList<String>();
        String url = "https://" + connection.getHost() + ":" + connection.getPort() + "/zosmf/restfiles/ds/" + dataSetName + "/member";
        try {
            Response response;
            if (options.getPattern().isPresent()) {
                url = url + "?pattern=" + options.getPattern().get();
            }
            if ((response = ZosDsnList.getResponse(connection, options, headers, url)).isEmpty()) {
                return members;
            }
            try {
                UtilRest.checkHttpErrors(response);
            }
            catch (Exception e) {
                UtilDataset.checkHttpErrors(e.getMessage(), dataSetName);
            }
            JSONObject results = (JSONObject)response.getResponsePhrase().orElse(new JSONObject());
            if (results.isEmpty()) {
                return members;
            }
            JSONArray items = (JSONArray)results.get("items");
            items.forEach(item -> {
                JSONObject datasetObj = (JSONObject)item;
                members.add(datasetObj.get("member").toString());
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return members;
    }

    public static List<Dataset> listDsn(ZOSConnection connection, String dataSetName, ListParams options) {
        Util.checkNullParameter(dataSetName == null, "dataSetName is null");
        Util.checkStateParameter(dataSetName.isEmpty(), "dataSetName is empty");
        Util.checkConnection(connection);
        HashMap<String, String> headers = new HashMap<String, String>();
        ArrayList<Dataset> datasets = new ArrayList<Dataset>();
        String url = "https://" + connection.getHost() + ":" + connection.getPort() + "/zosmf/restfiles/ds?";
        try {
            Response response;
            url = url + "dslevel=" + dataSetName;
            if (options.getVolume().isPresent()) {
                url = url + "&volser=" + options.getVolume().get();
            }
            if (options.getStart().isPresent()) {
                url = url + "&start=" + options.getStart().get();
            }
            if ((response = ZosDsnList.getResponse(connection, options, headers, url)).isEmpty()) {
                return datasets;
            }
            try {
                UtilRest.checkHttpErrors(response);
            }
            catch (Exception e) {
                UtilDataset.checkHttpErrors(e.getMessage(), dataSetName);
            }
            JSONObject results = (JSONObject)response.getResponsePhrase().orElse(new JSONObject());
            if (results.isEmpty()) {
                return datasets;
            }
            JSONArray items = (JSONArray)results.get("items");
            items.forEach(item -> {
                JSONObject datasetObj = (JSONObject)item;
                datasets.add(UtilDataset.createDatasetObjFromJson(datasetObj));
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return datasets;
    }

    public static Response getResponse(ZOSConnection connection, ListParams options, Map<String, String> headers, String url) throws Exception {
        LOG.debug(url);
        ZosDsnList.setHeaders(options, headers);
        ZoweRequest request = ZoweRequestFactory.buildRequest(connection, url, null, ZoweRequestType.VerbType.GET_JSON);
        request.setAdditionalHeaders(headers);
        return request.executeHttpRequest();
    }

    private static void setHeaders(ListParams options, Map<String, String> headers) {
        String key = (String)ZosmfHeaders.HEADERS.get((Object)"ACCEPT_ENCODING").get(0);
        String value = (String)ZosmfHeaders.HEADERS.get((Object)"ACCEPT_ENCODING").get(1);
        headers.put(key, value);
        if (options.getAttributes().isPresent()) {
            key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_ATTRIBUTES_BASE").get(0);
            value = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_ATTRIBUTES_BASE").get(1);
            headers.put(key, value);
        }
        if (options.getMaxLength().isPresent()) {
            key = "X-IBM-Max-Items";
            value = options.getMaxLength().get();
        } else {
            key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_MAX_ITEMS").get(0);
            value = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_ATTRIBUTES_BASE").get(1);
        }
        headers.put(key, value);
        if (options.getResponseTimeout().isPresent()) {
            key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_RESPONSE_TIMEOUT").get(0);
            value = options.getResponseTimeout().get();
            headers.put(key, value);
        }
        if (options.getRecall().isPresent()) {
            switch (options.getRecall().get().toLowerCase(Locale.ROOT)) {
                case "wait": {
                    key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_MIGRATED_RECALL_WAIT").get(0);
                    value = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_MIGRATED_RECALL_WAIT").get(1);
                    headers.put(key, value);
                    break;
                }
                case "nowait": {
                    key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_MIGRATED_RECALL_NO_WAIT").get(0);
                    value = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_MIGRATED_RECALL_NO_WAIT").get(1);
                    headers.put(key, value);
                    break;
                }
                case "error": {
                    key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_MIGRATED_RECALL_ERROR").get(0);
                    value = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_MIGRATED_RECALL_ERROR").get(1);
                    headers.put(key, value);
                }
            }
        }
    }
}

