/*
 * Decompiled with CFR 0.152.
 */
package zosfiles.input;

import java.util.HashMap;
import java.util.Optional;

public class DownloadParams {
    private Optional<String> file;
    private Optional<String> extension;
    private Optional<String> directory;
    private Optional<String[]> excludePatterns;
    private Optional<HashMap<String, String>> extensionMap;
    private Optional<Integer> maxConcurrentRequests;
    private Optional<Boolean> returnEtag;
    private Optional<Boolean> preserveOriginalLetterCase;
    private Optional<Boolean> failFast;
    private Optional<Boolean> binary;
    private Optional<Integer> encoding;
    private Optional<String> volume;
    private Optional<String> task;
    private Optional<String> responseTimeout;

    public DownloadParams(Builder builder) {
        this.file = builder.file != null ? Optional.ofNullable(builder.file) : Optional.empty();
        this.extension = builder.extension != null ? Optional.ofNullable(builder.extension) : Optional.empty();
        this.directory = builder.directory != null ? Optional.ofNullable(builder.directory) : Optional.empty();
        this.excludePatterns = builder.excludePatterns != null ? Optional.ofNullable(builder.excludePatterns) : Optional.empty();
        this.extensionMap = builder.extensionMap != null ? Optional.ofNullable(builder.extensionMap) : Optional.empty();
        this.maxConcurrentRequests = builder.maxConcurrentRequests != null ? Optional.ofNullable(builder.maxConcurrentRequests) : Optional.empty();
        this.returnEtag = builder.returnEtag != null ? Optional.ofNullable(builder.returnEtag) : Optional.empty();
        this.preserveOriginalLetterCase = builder.preserveOriginalLetterCase != null ? Optional.ofNullable(builder.preserveOriginalLetterCase) : Optional.empty();
        this.failFast = builder.failFast != null ? Optional.ofNullable(builder.failFast) : Optional.empty();
        this.binary = builder.binary != null ? Optional.ofNullable(builder.binary) : Optional.empty();
        this.encoding = builder.encoding != null ? Optional.ofNullable(builder.encoding) : Optional.empty();
        this.volume = builder.volume != null ? Optional.ofNullable(builder.volume) : Optional.empty();
        this.task = builder.task != null ? Optional.ofNullable(builder.task) : Optional.empty();
        this.responseTimeout = builder.responseTimeout != null ? Optional.ofNullable(builder.responseTimeout) : Optional.empty();
    }

    public Optional<String> getFile() {
        return this.file;
    }

    public Optional<String> getExtension() {
        return this.extension;
    }

    public Optional<String> getDirectory() {
        return this.directory;
    }

    public Optional<String[]> getExcludePatterns() {
        return this.excludePatterns;
    }

    public Optional<HashMap<String, String>> getExtensionMap() {
        return this.extensionMap;
    }

    public Optional<Integer> getNaxConcurrentRequests() {
        return this.maxConcurrentRequests;
    }

    public Optional<Boolean> getReturnEtag() {
        return this.returnEtag;
    }

    public Optional<Boolean> getPreserveOriginalLetterCase() {
        return this.preserveOriginalLetterCase;
    }

    public Optional<Boolean> getFailFast() {
        return this.failFast;
    }

    public Optional<Boolean> getBinary() {
        return this.binary;
    }

    public Optional<Integer> getEncoding() {
        return this.encoding;
    }

    public Optional<String> getVolume() {
        return this.volume;
    }

    public Optional<String> getTask() {
        return this.task;
    }

    public Optional<String> getResponseTimeout() {
        return this.responseTimeout;
    }

    public String toString() {
        return "DownloadOptions{file=" + this.file + ", extension=" + this.extension + ", directory=" + this.directory + ", excludePatterns=" + this.excludePatterns + ", extensionMap=" + this.extensionMap + ", maxConcurrentRequests=" + this.maxConcurrentRequests + ", returnEtag=" + this.returnEtag + ", preserveOriginalLetterCase=" + this.preserveOriginalLetterCase + ", failFast=" + this.failFast + ", binary=" + this.binary + ", encoding=" + this.encoding + ", volume=" + this.volume + ", task=" + this.task + ", responseTimeout=" + this.responseTimeout + "}";
    }

    public static class Builder {
        private String file;
        private String extension;
        private String directory;
        private String[] excludePatterns;
        private HashMap<String, String> extensionMap;
        private Integer maxConcurrentRequests;
        private Boolean returnEtag;
        private Boolean preserveOriginalLetterCase;
        private Boolean failFast;
        private Boolean binary;
        private Integer encoding;
        private String volume;
        private String task;
        private String responseTimeout;

        public Builder file(String file) {
            this.file = file;
            return this;
        }

        public Builder extension(String extension) {
            this.extension = extension;
            return this;
        }

        public Builder directory(String directory) {
            this.directory = directory;
            return this;
        }

        public Builder excludePatterns(String[] excludePatterns) {
            this.excludePatterns = excludePatterns;
            return this;
        }

        public Builder extensionMap(HashMap<String, String> extensionMap) {
            this.extensionMap = extensionMap;
            return this;
        }

        public Builder maxConcurrentRequests(Integer maxConcurrentRequests) {
            this.maxConcurrentRequests = maxConcurrentRequests;
            return this;
        }

        public Builder returnEtag(Boolean returnEtag) {
            this.returnEtag = returnEtag;
            return this;
        }

        public Builder preserveOriginalLetterCase(Boolean preserveOriginalLetterCase) {
            this.preserveOriginalLetterCase = preserveOriginalLetterCase;
            return this;
        }

        public Builder failFast(Boolean failFast) {
            this.failFast = failFast;
            return this;
        }

        public Builder binary(Boolean binary) {
            this.binary = binary;
            return this;
        }

        public Builder encoding(Integer encoding) {
            this.encoding = encoding;
            return this;
        }

        public Builder volume(String volume) {
            this.volume = volume;
            return this;
        }

        public Builder task(String task) {
            this.task = task;
            return this;
        }

        public Builder responseTimeout(String responseTimeout) {
            this.responseTimeout = responseTimeout;
            return this;
        }

        public DownloadParams build() {
            return new DownloadParams(this);
        }
    }
}

