/*
 * Decompiled with CFR 0.152.
 */
package zosfiles.input;

import java.util.Optional;

public class ListParams {
    private Optional<String> volume;
    private Optional<String> attributes;
    private Optional<String> maxLength;
    private Optional<String> start;
    private Optional<String> recall;
    private Optional<String> pattern;
    private Optional<String> responseTimeout;

    public ListParams(Builder builder) {
        this.volume = builder.volume != null ? Optional.ofNullable(builder.volume) : Optional.empty();
        this.attributes = builder.attributes != null ? Optional.ofNullable(builder.attributes) : Optional.empty();
        this.maxLength = builder.maxLength != null ? Optional.ofNullable(builder.maxLength) : Optional.empty();
        this.start = builder.start != null ? Optional.ofNullable(builder.start) : Optional.empty();
        this.recall = builder.recall != null ? Optional.ofNullable(builder.recall) : Optional.empty();
        this.pattern = builder.pattern != null ? Optional.ofNullable(builder.pattern) : Optional.empty();
        this.responseTimeout = builder.responseTimeout != null ? Optional.ofNullable(builder.responseTimeout) : Optional.empty();
    }

    public Optional<String> getVolume() {
        return this.volume;
    }

    public Optional<String> getAttributes() {
        return this.attributes;
    }

    public Optional<String> getMaxLength() {
        return this.maxLength;
    }

    public Optional<String> getStart() {
        return this.start;
    }

    public Optional<String> getRecall() {
        return this.recall;
    }

    public Optional<String> getPattern() {
        return this.pattern;
    }

    public Optional<String> getResponseTimeout() {
        return this.responseTimeout;
    }

    public String toString() {
        return "ListOptions{volume=" + this.volume + ", attributes=" + this.attributes + ", maxLength=" + this.maxLength + ", start=" + this.start + ", recall=" + this.recall + ", pattern=" + this.pattern + ", responseTimeout=" + this.responseTimeout + "}";
    }

    public static class Builder {
        private String volume;
        private String attributes;
        private String maxLength;
        private String start;
        private String recall;
        private String pattern;
        private String responseTimeout;

        public Builder volume(String volume) {
            this.volume = volume;
            return this;
        }

        public Builder attributes(String attributes) {
            this.attributes = attributes;
            return this;
        }

        public Builder maxLength(String maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public Builder start(String start) {
            this.start = start;
            return this;
        }

        public Builder recall(String recall) {
            this.recall = recall;
            return this;
        }

        public Builder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public Builder responseTimeout(String responseTimeout) {
            this.responseTimeout = responseTimeout;
            return this;
        }

        public ListParams build() {
            return new ListParams(this);
        }
    }
}

