/*
 * Decompiled with CFR 0.152.
 */
package zosfiles.samples;

import core.ZOSConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import zosfiles.ZosDsnDownload;
import zosfiles.input.DownloadParams;

public class DownloadDatasetTest {
    private static final Logger LOG = LogManager.getLogger(DownloadDatasetTest.class);

    public static void main(String[] args) throws Exception {
        String hostName = "XXX";
        String port = "XXX";
        String userName = "XXX";
        String password = "XXX";
        String datasetMember = "XXX";
        DownloadParams params = new DownloadParams.Builder().build();
        ZOSConnection connection = new ZOSConnection(hostName, port, userName, password);
        DownloadDatasetTest.downloadDsnMember(connection, datasetMember, params);
    }

    private static void downloadDsnMember(ZOSConnection connection, String name, DownloadParams params) throws IOException {
        try (InputStream inputStream = new ZosDsnDownload(connection).downloadDsn(name, params);){
            if (inputStream != null) {
                StringWriter writer = new StringWriter();
                IOUtils.copy(inputStream, (Writer)writer, "UTF8");
                String content = writer.toString();
                LOG.info(content);
            }
        }
    }
}

