/*
 * Decompiled with CFR 0.152.
 */
package zosjobs;

import core.ZOSConnection;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import rest.Response;
import rest.ZosmfHeaders;
import rest.ZoweRequest;
import rest.ZoweRequestFactory;
import rest.ZoweRequestType;
import utility.Util;
import utility.UtilJobs;
import utility.UtilRest;
import zosjobs.input.SubmitJclParms;
import zosjobs.input.SubmitJobParms;
import zosjobs.response.Job;

public class SubmitJobs {
    private static final Logger LOG = LogManager.getLogger(SubmitJobs.class);
    private ZOSConnection connection;

    public SubmitJobs(ZOSConnection connection) {
        this.connection = connection;
    }

    public Job submitJob(String jobDataSet) throws Exception {
        return this.submitJobCommon(new SubmitJobParms(jobDataSet));
    }

    public Job submitJobCommon(SubmitJobParms parms) throws Exception {
        ZoweRequest request;
        Response response;
        Util.checkNullParameter(parms == null, "parms is null");
        Util.checkStateParameter(!parms.getJobDataSet().isPresent(), "jobDataSet not specified");
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getPort() + "/zosmf/restjobs/jobs";
        LOG.debug(url);
        String fullyQualifiedDataset = "//'" + parms.getJobDataSet().get() + "'";
        JSONObject reqBody = new JSONObject();
        reqBody.put("file", fullyQualifiedDataset);
        LOG.debug(reqBody);
        if (parms.getJclSymbols().isPresent()) {
            // empty if block
        }
        if ((response = (request = ZoweRequestFactory.buildRequest(this.connection, url, reqBody.toString(), ZoweRequestType.VerbType.PUT_JSON)).executeHttpRequest()).isEmpty()) {
            return new Job.Builder().build();
        }
        try {
            UtilRest.checkHttpErrors(response);
        }
        catch (Exception e) {
            String errorMsg = e.getMessage();
            if (errorMsg.contains("400")) {
                throw new Exception("Body sent may be invalid. " + errorMsg);
            }
            throw new Exception("No results for submitted job. " + errorMsg);
        }
        return UtilJobs.createJobObjFromJson((JSONObject)response.getResponsePhrase().orElseThrow(Exception::new));
    }

    public Job submitJcl(String jcl, String internalReaderRecfm, String internalReaderLrecl) throws Exception {
        return this.submitJclCommon(new SubmitJclParms(jcl, internalReaderRecfm, internalReaderLrecl));
    }

    public Job submitJclCommon(SubmitJclParms parms) throws Exception {
        Response response;
        block10: {
            Util.checkConnection(this.connection);
            Util.checkNullParameter(parms == null, "parms is null");
            Util.checkStateParameter(!parms.getJcl().isPresent(), "jcl not specified");
            Util.checkStateParameter(parms.getJcl().get().isEmpty(), "jcl is empty");
            HashMap<String, String> headers = new HashMap<String, String>();
            String key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_INTRDR_MODE_TEXT").get(0);
            String value = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_INTRDR_MODE_TEXT").get(1);
            headers.put(key, value);
            if (parms.getInternalReaderLrecl().isPresent()) {
                key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_INTRDR_LRECL").get(0);
                headers.put(key, parms.getInternalReaderLrecl().get());
            } else {
                key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_INTRDR_LRECL_80").get(0);
                value = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_INTRDR_LRECL_80").get(1);
                headers.put(key, value);
            }
            if (parms.getInternalReaderRecfm().isPresent()) {
                key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_INTRDR_RECFM").get(0);
                headers.put(key, parms.getInternalReaderLrecl().get());
            } else {
                key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_INTRDR_RECFM_F").get(0);
                value = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_INTRDR_RECFM_F").get(1);
                headers.put(key, value);
            }
            if (parms.getJclSymbols().isPresent()) {
                // empty if block
            }
            key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_INTRDR_CLASS_A").get(0);
            value = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_INTRDR_CLASS_A").get(1);
            headers.put(key, value);
            String url = "https://" + this.connection.getHost() + ":" + this.connection.getPort() + "/zosmf/restjobs/jobs";
            LOG.debug(url);
            String body = parms.getJcl().get();
            ZoweRequest request = ZoweRequestFactory.buildRequest(this.connection, url, body, ZoweRequestType.VerbType.PUT_TEXT);
            request.setAdditionalHeaders(headers);
            response = request.executeHttpRequest();
            if (response.isEmpty()) {
                return new Job.Builder().build();
            }
            try {
                UtilRest.checkHttpErrors(response);
            }
            catch (Exception e) {
                String errorMsg = e.getMessage();
                if (!errorMsg.contains("400")) break block10;
                throw new Exception("Body sent may be invalid. " + errorMsg);
            }
        }
        JSONParser parser = new JSONParser();
        JSONObject json = null;
        try {
            json = (JSONObject)parser.parse((String)response.getResponsePhrase().get());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return UtilJobs.createJobObjFromJson(json);
    }
}

