/*
 * Decompiled with CFR 0.152.
 */
package zostso;

import core.ZOSConnection;
import java.util.Optional;
import utility.Util;
import zostso.IssueResponse;
import zostso.SendResponse;
import zostso.SendTso;
import zostso.StartStopResponses;
import zostso.StartTso;
import zostso.StopTso;
import zostso.input.StartTsoParams;

public class IssueTso {
    private ZOSConnection connection;

    public IssueTso(ZOSConnection connection) {
        this.connection = connection;
    }

    public IssueResponse issueTsoCommand(String accountNumber, String command) throws Exception {
        return this.issueTsoCommand(accountNumber, command, null);
    }

    public IssueResponse issueTsoCommand(String accountNumber, String command, StartTsoParams startParams) throws Exception {
        Util.checkConnection(this.connection);
        Util.checkNullParameter(accountNumber == null, "accountNumber is null");
        Util.checkNullParameter(command == null, "command is null");
        Util.checkStateParameter(accountNumber.isEmpty(), "accountNumber not specified");
        Util.checkStateParameter(command.isEmpty(), "command not specified");
        IssueResponse response = new IssueResponse(false, null, false, null, null, null);
        StartStopResponses startResponse = StartTso.start(this.connection, accountNumber, startParams);
        response.setStartResponse(Optional.ofNullable(startResponse));
        if (response.getStartResponse().isPresent() && !response.getStartResponse().get().isSuccess()) {
            throw new Exception("TSO address space failed to start. Error: " + (response.getStartResponse().isPresent() ? response.getStartResponse().get().getFailureResponse() : "Unknown error"));
        }
        response.setZosmfResponse(Optional.ofNullable(startResponse.getZosmfTsoResponse().get()));
        SendResponse sendResponse = SendTso.sendDataToTSOCollect(this.connection, response.getStartResponse().get().getServletKey().get(), command);
        response.setSuccess(sendResponse.getSuccess());
        response.setZosmfResponse(Optional.of(sendResponse.getZosmfResponse().get().get(0)));
        startResponse.setCollectedResponses(sendResponse.getZosmfResponse().get());
        response.setCommandResponses(sendResponse.getCommandResponse());
        StopTso stopTso = new StopTso(this.connection);
        response.setStopResponse(Optional.ofNullable(stopTso.stop(response.getStartResponse().get().getServletKey().get())));
        return response;
    }
}

