/*
 * Decompiled with CFR 0.152.
 */
package zostso;

import core.ZOSConnection;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import rest.Response;
import rest.ZoweRequest;
import rest.ZoweRequestFactory;
import rest.ZoweRequestType;
import utility.Util;
import utility.UtilRest;
import utility.UtilTso;
import zostso.CollectedResponses;
import zostso.SendResponse;
import zostso.input.SendTsoParms;
import zostso.zosmf.TsoMessage;
import zostso.zosmf.TsoMessages;
import zostso.zosmf.TsoResponseMessage;
import zostso.zosmf.ZosmfTsoResponse;

public class SendTso {
    private static final Logger LOG = LogManager.getLogger(SendTso.class);

    public static SendResponse sendDataToTSOCollect(ZOSConnection connection, String servletKey, String data) throws Exception {
        Util.checkNullParameter(servletKey == null, "servletKey is null");
        Util.checkNullParameter(data == null, "data is null");
        Util.checkStateParameter(servletKey.isEmpty(), "servletKey not specified");
        Util.checkStateParameter(data.isEmpty(), "data not specified");
        ZosmfTsoResponse putResponse = SendTso.sendDataToTSOCommon(connection, new SendTsoParms(servletKey, data));
        CollectedResponses responses = SendTso.getAllResponses(connection, putResponse);
        return SendTso.createResponse(responses);
    }

    public static ZosmfTsoResponse sendDataToTSOCommon(ZOSConnection connection, SendTsoParms commandParms) throws Exception {
        Util.checkConnection(connection);
        Util.checkNullParameter(commandParms == null, "sendTsoParms is null");
        Util.checkStateParameter(commandParms.getData().isEmpty(), "sendTsoParms data not specified");
        Util.checkStateParameter(commandParms.getSevletKey().isEmpty(), "sendTsoParms sevletKey not specified");
        String url = "https://" + connection.getHost() + ":" + connection.getPort() + "/zosmf/tsoApp/tso/" + commandParms.getSevletKey() + "?readReply=false";
        LOG.debug("SendTso::sendDataToTSOCommon - url {}", (Object)url);
        TsoResponseMessage tsoResponseMessage = new TsoResponseMessage(Optional.of("0100"), Optional.ofNullable(commandParms.getData()));
        String jobObjBody = SendTso.getTsoResponseSendMessage(tsoResponseMessage);
        ZoweRequest request = ZoweRequestFactory.buildRequest(connection, url, jobObjBody, ZoweRequestType.VerbType.PUT_JSON);
        Response response = request.executeHttpRequest();
        if (response.isEmpty()) {
            return new ZosmfTsoResponse.Builder().build();
        }
        try {
            UtilRest.checkHttpErrors(response);
        }
        catch (Exception e) {
            String errorMsg = e.getMessage();
            throw new Exception("No results from executing tso command after getting TSO address space. " + errorMsg);
        }
        return UtilTso.getZosmfTsoResponse(response);
    }

    private static String getTsoResponseSendMessage(TsoResponseMessage tsoResponseMessage) throws Exception {
        String message = "{\"TSO RESPONSE\":{\"VERSION\":\"" + tsoResponseMessage.getVersion().orElseThrow(Exception::new) + "\",\"DATA\":\"" + tsoResponseMessage.getData().orElseThrow(Exception::new) + "\"}}";
        LOG.debug("SendTo::getTsoResponseSendMessage - message {}", (Object)message);
        return message;
    }

    private static CollectedResponses getAllResponses(ZOSConnection connection, ZosmfTsoResponse tso) throws Exception {
        boolean done = false;
        StringBuilder messages = new StringBuilder();
        ArrayList<ZosmfTsoResponse> tsos = new ArrayList<ZosmfTsoResponse>();
        tsos.add(tso);
        while (!done) {
            if (tso.getTsoData().isPresent()) {
                for (TsoMessages tsoDatum : tso.getTsoData().get()) {
                    if (tsoDatum.getTsoMessage().isPresent()) {
                        TsoMessage tsoMsg = tsoDatum.getTsoMessage().orElseThrow(Exception::new);
                        String data = tsoMsg.getData().orElseThrow(Exception::new);
                        messages.append(data + "\n");
                        continue;
                    }
                    if (!tsoDatum.getTsoPrompt().isPresent() || messages.length() <= 0) continue;
                    done = true;
                }
            }
            if (done) continue;
            tso = SendTso.getDataFromTSO(connection, tso.getServletKey().orElseThrow(Exception::new));
            tsos.add(tso);
        }
        return new CollectedResponses(tsos, messages.toString());
    }

    private static ZosmfTsoResponse getDataFromTSO(ZOSConnection connection, String servletKey) throws Exception {
        Util.checkConnection(connection);
        String url = "https://" + connection.getHost() + ":" + connection.getPort() + "/zosmf/tsoApp/tso/" + servletKey;
        LOG.debug("SendTso::getDataFromTSO - url {}", (Object)url);
        ZoweRequest request = ZoweRequestFactory.buildRequest(connection, url, "", ZoweRequestType.VerbType.PUT_JSON);
        Response response = request.executeHttpRequest();
        if (response.isEmpty()) {
            return new ZosmfTsoResponse.Builder().build();
        }
        try {
            UtilRest.checkHttpErrors(response);
        }
        catch (Exception e) {
            String errorMsg = e.getMessage();
            throw new Exception("Follow up TSO Messages from TSO command cannot be retrieved. " + errorMsg);
        }
        return UtilTso.getZosmfTsoResponse(response);
    }

    private static SendResponse createResponse(CollectedResponses responses) {
        return new SendResponse(true, responses.getTsos().get(), responses.getMessages().get());
    }
}

