/*
 * Decompiled with CFR 0.152.
 */
package zostso;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import zostso.zosmf.ZosmfMessages;
import zostso.zosmf.ZosmfTsoResponse;

public class StartStopResponses {
    private Optional<ZosmfTsoResponse> zosmfTsoResponse;
    private Optional<List<ZosmfTsoResponse>> collectedResponses;
    private Optional<String> failureResponse;
    private Optional<String> servletKey;
    private Optional<String> messages;
    private boolean success;

    public StartStopResponses(ZosmfTsoResponse zosmfTsoResponse) {
        this.zosmfTsoResponse = Optional.ofNullable(zosmfTsoResponse);
        if (zosmfTsoResponse.getMsgData().isPresent()) {
            this.success = false;
            ZosmfMessages zOSMFMsg = zosmfTsoResponse.getMsgData().get().get(0);
            this.failureResponse = Optional.of(zOSMFMsg.getMessageText().orElse("zOSMF unknown error response"));
        } else {
            this.success = true;
            this.failureResponse = Optional.empty();
        }
        if (zosmfTsoResponse.getServletKey().isPresent()) {
            this.servletKey = Optional.of(zosmfTsoResponse.getServletKey().get());
        }
        StringBuilder buildMessage = new StringBuilder();
        List tsoMsgLst = zosmfTsoResponse.getTsoData().orElse(new ArrayList());
        tsoMsgLst.forEach(msg -> buildMessage.append(msg));
        this.messages = Optional.of(buildMessage.toString());
    }

    public Optional<ZosmfTsoResponse> getZosmfTsoResponse() {
        return this.zosmfTsoResponse;
    }

    public Optional<List<ZosmfTsoResponse>> getCollectedResponses() {
        return this.collectedResponses;
    }

    public void setCollectedResponses(List<ZosmfTsoResponse> collectedResponses) {
        this.collectedResponses = Optional.ofNullable(collectedResponses);
    }

    public Optional<String> getFailureResponse() {
        return this.failureResponse;
    }

    public Optional<String> getServletKey() {
        return this.servletKey;
    }

    public void setServletKey(String servletKey) {
        this.servletKey = Optional.ofNullable(servletKey);
    }

    public Optional<String> getMessages() {
        return this.messages;
    }

    public void setMessages(String messages) {
        this.messages = Optional.ofNullable(messages);
    }

    public boolean isSuccess() {
        return this.success;
    }
}

