/*
 * Decompiled with CFR 0.152.
 */
package zostso;

import core.ZOSConnection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import rest.Response;
import rest.ZoweRequest;
import rest.ZoweRequestFactory;
import rest.ZoweRequestType;
import utility.Util;
import utility.UtilRest;
import utility.UtilTso;
import zostso.StartStopResponses;
import zostso.input.StartTsoParams;
import zostso.zosmf.ZosmfTsoResponse;

public class StartTso {
    private static final Logger LOG = LogManager.getLogger(StartTso.class);

    public static StartStopResponses start(ZOSConnection connection, String accountNumber, StartTsoParams parms) throws Exception {
        Util.checkNullParameter(accountNumber == null, "accountNumber is null");
        Util.checkStateParameter(accountNumber.isEmpty(), "accountNumber not specified");
        StartTsoParams customParms = parms == null ? StartTso.setDefaultAddressSpaceParams(null, Util.encodeURIComponent(accountNumber)) : StartTso.setDefaultAddressSpaceParams(parms, Util.encodeURIComponent(accountNumber));
        ZosmfTsoResponse zosmfResponse = StartTso.startCommon(connection, customParms);
        return new StartStopResponses(zosmfResponse);
    }

    public static ZosmfTsoResponse startCommon(ZOSConnection connection, StartTsoParams commandParms) throws Exception {
        Util.checkConnection(connection);
        Util.checkNullParameter(commandParms == null, "commandParms is null");
        String url = StartTso.getResourcesQuery(connection, commandParms);
        LOG.debug("StartTso::startCommon - url {}", (Object)url);
        ZoweRequest request = ZoweRequestFactory.buildRequest(connection, url, null, ZoweRequestType.VerbType.POST_JSON);
        Response response = request.executeHttpRequest();
        if (response.isEmpty()) {
            return new ZosmfTsoResponse.Builder().build();
        }
        try {
            UtilRest.checkHttpErrors(response);
        }
        catch (Exception e) {
            String errorMsg = e.getMessage();
            throw new Exception("No results from executing tso command while setting up TSO address space. " + errorMsg);
        }
        return UtilTso.getZosmfTsoResponse(response);
    }

    private static StartTsoParams setDefaultAddressSpaceParams(StartTsoParams parms, String accountNumber) {
        String proc = parms == null || !parms.logonProcedure.isPresent() ? "IZUFPROC" : parms.getLogonProcedure().get();
        String chset = parms == null || !parms.characterSet.isPresent() ? "697" : parms.getCharacterSet().get();
        String cpage = parms == null || !parms.codePage.isPresent() ? "1047" : parms.getCodePage().get();
        String rowNum = parms == null || !parms.rows.isPresent() ? "24" : parms.getRows().get();
        String cols = parms == null || !parms.columns.isPresent() ? "80" : parms.getColumns().get();
        String rSize = parms == null || !parms.regionSize.isPresent() ? "4096" : parms.getRegionSize().get();
        return new StartTsoParams(proc, chset, cpage, rowNum, cols, accountNumber, rSize);
    }

    private static String getResourcesQuery(ZOSConnection connection, StartTsoParams parms) {
        String query = "https://" + connection.getHost() + ":" + connection.getPort();
        query = query + "/zosmf/tsoApp/tso?";
        query = query + "acct=" + parms.account.get() + "&";
        query = query + "proc=" + parms.logonProcedure.get() + "&";
        query = query + "chset=" + parms.characterSet.get() + "&";
        query = query + "cpage=" + parms.codePage.get() + "&";
        query = query + "rows=" + parms.rows.get() + "&";
        query = query + "cols=" + parms.columns.get() + "&";
        query = query + "rsize=" + parms.regionSize.get();
        return query;
    }
}

