/*
 * Decompiled with CFR 0.152.
 */
package zostso;

import core.ZOSConnection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.simple.JSONObject;
import rest.Response;
import rest.ZoweRequest;
import rest.ZoweRequestFactory;
import rest.ZoweRequestType;
import utility.Util;
import utility.UtilRest;
import utility.UtilTso;
import zostso.StartStopResponse;
import zostso.TsoResponseService;
import zostso.input.StopTsoParms;
import zostso.zosmf.ZosmfTsoResponse;

public class StopTso {
    private static final Logger LOG = LogManager.getLogger(StopTso.class);
    private ZOSConnection connection;

    public StopTso(ZOSConnection connection) {
        this.connection = connection;
    }

    public ZosmfTsoResponse stopCommon(StopTsoParms commandParms) throws Exception {
        Util.checkConnection(this.connection);
        Util.checkNullParameter(commandParms == null, "commandParms is null");
        Util.checkStateParameter(!commandParms.getServletKey().isPresent(), "servletKey not specified");
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getPort() + "/zosmf/tsoApp/tso/" + commandParms.getServletKey().get();
        LOG.debug("StopTso::stopCommon url {}", (Object)url);
        ZoweRequest request = ZoweRequestFactory.buildRequest(this.connection, url, null, ZoweRequestType.VerbType.DELETE_JSON);
        Response response = request.executeHttpRequest();
        if (response.isEmpty()) {
            return new ZosmfTsoResponse.Builder().build();
        }
        try {
            UtilRest.checkHttpErrors(response);
        }
        catch (Exception e) {
            String errorMsg = e.getMessage();
            throw new Exception("Failed to stop active TSO address space. " + errorMsg);
        }
        JSONObject result = (JSONObject)response.getResponsePhrase().get();
        return UtilTso.parseJsonStopResponse(result);
    }

    public StartStopResponse stop(String servletKey) throws Exception {
        Util.checkNullParameter(servletKey == null, "servletKey is null");
        Util.checkStateParameter(servletKey.isEmpty(), "servletKey not specified");
        StopTsoParms commandParms = new StopTsoParms(servletKey);
        ZosmfTsoResponse zosmfResponse = this.stopCommon(commandParms);
        return TsoResponseService.populateStartAndStop(zosmfResponse);
    }
}

