/*
 * Decompiled with CFR 0.152.
 */
package zostso.samples;

import core.ZOSConnection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import zostso.IssueResponse;
import zostso.IssueTso;
import zostso.StartStopResponses;
import zostso.zosmf.ZosmfTsoResponse;

public class IssueTsoCommandTest {
    private static final Logger LOG = LogManager.getLogger(IssueTsoCommandTest.class);

    public static void main(String[] args) {
        String hostName = "XXX";
        String port = "XXX";
        String userName = "XXX";
        String password = "XXX";
        String command = "XXX";
        String accountNumber = "XXX";
        ZOSConnection connection = new ZOSConnection(hostName, port, userName, password);
        IssueResponse response = null;
        try {
            response = IssueTsoCommandTest.tstTsoConsoleCmdByIssue(connection, accountNumber, command);
        }
        catch (Exception e) {
            LOG.info(e.getMessage());
        }
        if (response != null && response.getStartResponse().isPresent()) {
            LOG.info(response.getStartResponse().get().isSuccess());
            LOG.info(response.getStartResponse().get().getZosmfTsoResponse().get().getVer());
            StartStopResponses startResponses = response.getStartResponse().get();
            startResponses.getCollectedResponses().get().forEach(LOG::info);
            List<ZosmfTsoResponse> zosmfTsoResponses = startResponses.getCollectedResponses().get();
            zosmfTsoResponses.forEach(tso -> tso.getTsoData().get().forEach(msg -> {
                if (!msg.getTsoPrompt().isPresent()) {
                    LOG.info(msg.getTsoMessage().get().getVersion() + " " + msg.getTsoMessage().get().getData());
                }
            }));
        }
    }

    public static IssueResponse tstTsoConsoleCmdByIssue(ZOSConnection connection, String accountNumber, String cmd) throws Exception {
        IssueResponse response;
        IssueTso issueTso = new IssueTso(connection);
        try {
            response = issueTso.issueTsoCommand(accountNumber, cmd);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
        return response;
    }
}

