/*
 * This program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v2.0 which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-v20.html
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Copyright Contributors to the Zowe Project.
 */
package zowe.client.sdk.utility;

/**
 * Utility class will handle common sequences of I/O, issue messages, and throw errors as necessary.
 *
 * @author Nikunj Goyal
 * @version 1.0
 */
public class UtilIO {

    /**
     * File delimiter
     */
    public static final String FILE_DELIM = "/";

    /**
     * UTF8 identifier
     */
    public static final String UTF8 = "UTF8";

    /**
     * Windows OS identifier
     */
    public static String OS_WIN32 = "win32";

    /**
     * Mac OS identifier
     */
    public static String OS_MAC = "darwin";

    /**
     * Linux OS identifier
     */
    public static String OS_LINUX = "linux";

}
