/*
 * Decompiled with CFR 0.152.
 */
package examples.zosfiles;

import core.ZOSConnection;
import examples.ZosConnection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import rest.Response;
import zosfiles.ZosDsn;
import zosfiles.input.CreateParams;

public class CreateDataset
extends ZosConnection {
    private static final Logger LOG = LogManager.getLogger(CreateDataset.class);
    private static ZOSConnection connection;

    public static void main(String[] args) throws Exception {
        String dataSetName = "XXX";
        connection = new ZOSConnection("XXX", "XXX", "XXX", "XXX");
        CreateDataset.createDataSet(dataSetName);
    }

    public static void createDataSet(String dataSetName) throws Exception {
        ZosDsn zosDsn = new ZosDsn(connection);
        Response response = zosDsn.createDsn(dataSetName, CreateDataset.partitioned());
        LOG.info("http response code " + response.getStatusCode());
    }

    public static CreateParams binary() {
        return new CreateParams.Builder().dsorg("PO").alcunit("CYL").primary(10).secondary(10).dirblk(25).recfm("U").blksize(27998).lrecl(27998).build();
    }

    public static CreateParams c() {
        return new CreateParams.Builder().dsorg("PO").alcunit("CYL").primary(1).secondary(1).dirblk(25).recfm("VB").blksize(32760).lrecl(260).build();
    }

    public static CreateParams classic() {
        return new CreateParams.Builder().dsorg("PO").alcunit("CYL").primary(1).secondary(1).dirblk(25).recfm("FB").blksize(6160).lrecl(80).build();
    }

    public static CreateParams partitioned() {
        return new CreateParams.Builder().dsorg("PO").alcunit("CYL").primary(1).secondary(1).dirblk(5).recfm("FB").blksize(6160).lrecl(80).build();
    }

    public static CreateParams sequential() {
        return new CreateParams.Builder().dsorg("PS").alcunit("CYL").primary(1).secondary(1).recfm("FB").blksize(6160).lrecl(80).build();
    }
}

