/*
 * Decompiled with CFR 0.152.
 */
package zosfiles;

import core.ZOSConnection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.simple.JSONObject;
import rest.Response;
import rest.ZoweRequest;
import rest.ZoweRequestFactory;
import rest.ZoweRequestType;
import utility.Crud;
import utility.Util;
import utility.UtilDataset;
import utility.UtilRest;
import zosfiles.input.CreateParams;

public class ZosDsn {
    private static final Logger LOG = LogManager.getLogger(ZosDsn.class);
    private final ZOSConnection connection;

    public ZosDsn(ZOSConnection connection) {
        Util.checkConnection(connection);
        this.connection = connection;
    }

    public Response writeDsn(String dataSetName, String content) throws Exception {
        Util.checkNullParameter(content == null, "content is null");
        Util.checkNullParameter(dataSetName == null, "dataSetName is null");
        Util.checkIllegalParameter(dataSetName.isEmpty(), "dataSetName not specified");
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restfiles/ds/" + Util.encodeURIComponent(dataSetName);
        LOG.debug(url);
        ZoweRequest request = ZoweRequestFactory.buildRequest(this.connection, url, content, ZoweRequestType.VerbType.PUT_TEXT);
        Response response = request.executeHttpRequest();
        try {
            UtilRest.checkHttpErrors(response);
        }
        catch (Exception e) {
            UtilDataset.checkHttpErrors(e.getMessage(), Arrays.asList(dataSetName), Crud.type.write);
        }
        return response;
    }

    public Response writeDsn(String dataSetName, String member, String content) throws Exception {
        Util.checkNullParameter(dataSetName == null, "dataSetName is null");
        Util.checkIllegalParameter(dataSetName.isEmpty(), "dataSetName not specified");
        Util.checkNullParameter(member == null, "member is null");
        Util.checkIllegalParameter(member.isEmpty(), "member not specified");
        return this.writeDsn(String.format("%s(%s)", dataSetName, member), content);
    }

    public Response deleteDsn(String dataSetName) throws Exception {
        Util.checkNullParameter(dataSetName == null, "dataSetName is null");
        Util.checkIllegalParameter(dataSetName.isEmpty(), "dataSetName not specified");
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restfiles/ds/" + Util.encodeURIComponent(dataSetName);
        LOG.debug(url);
        ZoweRequest request = ZoweRequestFactory.buildRequest(this.connection, url, null, ZoweRequestType.VerbType.DELETE_JSON);
        Response response = request.executeHttpRequest();
        try {
            UtilRest.checkHttpErrors(response);
        }
        catch (Exception e) {
            UtilDataset.checkHttpErrors(e.getMessage(), Arrays.asList(dataSetName), Crud.type.delete);
        }
        return response;
    }

    public Response deleteDsn(String dataSetName, String member) throws Exception {
        Util.checkNullParameter(dataSetName == null, "dataSetName is null");
        Util.checkIllegalParameter(dataSetName.isEmpty(), "dataSetName not specified");
        Util.checkNullParameter(member == null, "member is null");
        Util.checkIllegalParameter(member.isEmpty(), "member not specified");
        return this.deleteDsn(String.format("%s(%s)", dataSetName, member));
    }

    public Response createDsn(String dataSetName, CreateParams params) throws Exception {
        Util.checkNullParameter(params == null, "params is null");
        Util.checkNullParameter(dataSetName == null, "dataSetName is null");
        Util.checkIllegalParameter(dataSetName.isEmpty(), "dataSetName not specified");
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restfiles/ds/" + Util.encodeURIComponent(dataSetName);
        LOG.debug(url);
        String body = ZosDsn.buildBody(params);
        ZoweRequest request = ZoweRequestFactory.buildRequest(this.connection, url, body, ZoweRequestType.VerbType.POST_JSON);
        Response response = request.executeHttpRequest();
        try {
            UtilRest.checkHttpErrors(response);
        }
        catch (Exception e) {
            UtilDataset.checkHttpErrors(e.getMessage(), Arrays.asList(dataSetName), Crud.type.create);
        }
        return response;
    }

    private static String buildBody(CreateParams params) {
        HashMap jsonMap = new HashMap();
        params.getVolser().ifPresent(v -> jsonMap.put("volser", v));
        params.getUnit().ifPresent(v -> jsonMap.put("unit", v));
        params.getDsorg().ifPresent(v -> jsonMap.put("dsorg", v));
        params.getAlcunit().ifPresent(v -> jsonMap.put("alcunit", v));
        params.getPrimary().ifPresent(v -> jsonMap.put("primary", v));
        params.getSecondary().ifPresent(v -> jsonMap.put("secondary", v));
        params.getDirblk().ifPresent(v -> jsonMap.put("dirblk", v));
        params.getAvgblk().ifPresent(v -> jsonMap.put("avgblk", v));
        params.getRecfm().ifPresent(v -> jsonMap.put("recfm", v));
        params.getBlksize().ifPresent(v -> jsonMap.put("blksize", v));
        params.getLrecl().ifPresent(v -> jsonMap.put("lrecl", v));
        params.getStorclass().ifPresent(v -> jsonMap.put("storclass", v));
        params.getStorclass().ifPresent(v -> jsonMap.put("mgntclass", v));
        params.getMgntclass().ifPresent(v -> jsonMap.put("mgntclass", v));
        params.getDataclass().ifPresent(v -> jsonMap.put("dataclass", v));
        params.getDsntype().ifPresent(v -> jsonMap.put("dsntype", v));
        JSONObject jsonRequestBody = new JSONObject((Map)jsonMap);
        LOG.debug(jsonRequestBody);
        return jsonRequestBody.toString();
    }
}

