/*
 * Decompiled with CFR 0.152.
 */
package zosfiles;

import core.ZOSConnection;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.simple.JSONObject;
import rest.Response;
import rest.ZoweRequest;
import rest.ZoweRequestFactory;
import rest.ZoweRequestType;
import utility.Crud;
import utility.Util;
import utility.UtilDataset;
import utility.UtilRest;
import zosfiles.input.CopyParams;

public class ZosDsnCopy {
    private static final Logger LOG = LogManager.getLogger(ZosDsnCopy.class);
    private final ZOSConnection connection;

    public ZosDsnCopy(ZOSConnection connection) {
        Util.checkConnection(connection);
        this.connection = connection;
    }

    public Response copy(CopyParams params) throws Exception {
        Util.checkNullParameter(params == null, "params is null");
        Util.checkIllegalParameter(params.getFromDataSet().isEmpty(), "fromDataSetName not specified");
        Util.checkIllegalParameter(params.getToDataSet().isEmpty(), "toDataSetName not specified");
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restfiles/ds/";
        if (params.getToVolser().isPresent()) {
            url = url + "-(" + params.getToVolser().get() + ")/";
        }
        String toDataSet = params.getToDataSet().get();
        String fromDataSet = params.getFromDataSet().get();
        url = url + Util.encodeURIComponent(toDataSet);
        LOG.debug(url);
        String body = this.buildBody(params);
        ZoweRequest request = ZoweRequestFactory.buildRequest(this.connection, url, body, ZoweRequestType.VerbType.PUT_JSON);
        Response response = request.executeHttpRequest();
        try {
            UtilRest.checkHttpErrors(response);
        }
        catch (Exception e) {
            UtilDataset.checkHttpErrors(e.getMessage(), Arrays.asList(toDataSet, fromDataSet), Crud.type.copy);
        }
        return response;
    }

    public Response copy(String fromDataSetName, String toDataSetName, boolean replace, boolean copyAllMembers) throws Exception {
        return this.copy(new CopyParams.Builder().fromDataSet(fromDataSetName).toDataSet(toDataSetName).replace(replace).copyAllMembers(copyAllMembers).build());
    }

    private String buildBody(CopyParams params) throws Exception {
        String fromDataSetName = params.getFromDataSet().orElseThrow(() -> new Exception("dataset not specified"));
        boolean isFullPartitionCopy = params.isCopyAllMembers();
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        jsonMap.put("request", "copy");
        String member = "";
        int startMemberIndex = fromDataSetName.indexOf("(");
        if (startMemberIndex > 0) {
            member = fromDataSetName.substring(startMemberIndex + 1, fromDataSetName.length() - 1);
            fromDataSetName = fromDataSetName.substring(0, startMemberIndex);
        }
        HashMap<String, String> fromDataSetReq = new HashMap<String, String>();
        fromDataSetReq.put("dsn", fromDataSetName);
        if (member.length() > 0) {
            fromDataSetReq.put("member", member);
        } else if (isFullPartitionCopy) {
            fromDataSetReq.put("member", "*");
        }
        JSONObject fromDataSetObj = new JSONObject(fromDataSetReq);
        jsonMap.put("from-dataset", fromDataSetObj);
        jsonMap.put("replace", params.isReplace());
        if (params.getFromVolser().isPresent()) {
            jsonMap.put("volser", params.getFromVolser());
        }
        JSONObject jsonRequestBody = new JSONObject(jsonMap);
        LOG.debug(jsonRequestBody);
        return jsonRequestBody.toString();
    }
}

