/*
 * Decompiled with CFR 0.152.
 */
package zosjobs;

import core.ZOSConnection;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.simple.JSONObject;
import rest.Response;
import rest.ZoweRequest;
import rest.ZoweRequestFactory;
import rest.ZoweRequestType;
import utility.Util;
import utility.UtilJobs;
import utility.UtilRest;
import zosjobs.input.ModifyJobParams;
import zosjobs.response.Job;

public class CancelJobs {
    private static final Logger LOG = LogManager.getLogger(CancelJobs.class);
    private final ZOSConnection connection;

    public CancelJobs(ZOSConnection connection) {
        Util.checkConnection(connection);
        this.connection = connection;
    }

    public Response cancelJob(String jobName, String jobId, String version) throws Exception {
        return this.cancelJobsCommon(new ModifyJobParams.Builder(jobName, jobId).version(version).build());
    }

    public Response cancelJobForJob(Job job, String version) throws Exception {
        return this.cancelJobsCommon(new ModifyJobParams.Builder(job.getJobName().orElse(null), job.getJobId().orElse(null)).version(version).build());
    }

    public Response cancelJobsCommon(ModifyJobParams params) throws Exception {
        UtilJobs.checkModifyJobParameters(params);
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restjobs/jobs/" + params.getJobName().get() + "/" + params.getJobId().get();
        LOG.debug(url);
        String version = params.getVersion().orElse("1.0");
        if (!version.isEmpty()) {
            if ("1.0".equals(version)) {
                LOG.debug("version 1.0 specified which will result in asynchronous processing for the request");
            } else if ("2.0".equals(version)) {
                LOG.debug("version 2.0 specified which will result in synchronous processing for the request");
            } else {
                throw new Exception("invalid version specified");
            }
        }
        HashMap<String, String> jsonMap = new HashMap<String, String>();
        jsonMap.put("request", "cancel");
        jsonMap.put("version", version);
        JSONObject jsonRequestBody = new JSONObject(jsonMap);
        LOG.debug(jsonRequestBody);
        ZoweRequest request = ZoweRequestFactory.buildRequest(this.connection, url, jsonRequestBody.toString(), ZoweRequestType.VerbType.PUT_JSON);
        Response response = request.executeHttpRequest();
        try {
            UtilRest.checkHttpErrors(response);
        }
        catch (Exception e) {
            UtilJobs.throwHttpException(params, e);
        }
        return response;
    }
}

