/*
 * Decompiled with CFR 0.152.
 */
package zosjobs;

import core.ZOSConnection;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import rest.Response;
import rest.ZosmfHeaders;
import rest.ZoweRequest;
import rest.ZoweRequestFactory;
import rest.ZoweRequestType;
import utility.Util;
import utility.UtilJobs;
import utility.UtilRest;
import zosjobs.input.SubmitJclParams;
import zosjobs.input.SubmitJobParams;
import zosjobs.response.Job;

public class SubmitJobs {
    private static final Logger LOG = LogManager.getLogger(SubmitJobs.class);
    private final ZOSConnection connection;

    public SubmitJobs(ZOSConnection connection) {
        Util.checkConnection(connection);
        this.connection = connection;
    }

    public Job submitJob(String jobDataSet) throws Exception {
        return this.submitJobCommon(new SubmitJobParams(jobDataSet));
    }

    public Job submitJobCommon(SubmitJobParams params) throws Exception {
        ZoweRequest request;
        Response response;
        Util.checkNullParameter(params == null, "params is null");
        Util.checkIllegalParameter(params.getJobDataSet().isEmpty(), "jobDataSet not specified");
        Util.checkIllegalParameter(params.getJobDataSet().get().isEmpty(), "jobDataSet not specified");
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restjobs/jobs";
        LOG.debug(url);
        String fullyQualifiedDataset = "//'" + Util.encodeURIComponent(params.getJobDataSet().get()) + "'";
        HashMap<String, CallSite> jsonMap = new HashMap<String, CallSite>();
        jsonMap.put("file", (CallSite)((Object)fullyQualifiedDataset));
        JSONObject jsonRequestBody = new JSONObject(jsonMap);
        LOG.debug(jsonRequestBody);
        if (params.getJclSymbols().isPresent()) {
            // empty if block
        }
        if ((response = (request = ZoweRequestFactory.buildRequest(this.connection, url, jsonRequestBody.toString(), ZoweRequestType.VerbType.PUT_JSON)).executeHttpRequest()).isEmpty()) {
            return new Job.Builder().build();
        }
        try {
            UtilRest.checkHttpErrors(response);
        }
        catch (Exception e) {
            String errorMsg = e.getMessage();
            if (errorMsg.contains("400")) {
                throw new Exception("Body sent may be invalid. " + errorMsg);
            }
            e.printStackTrace();
            throw new Exception("No results for submitted job. " + errorMsg);
        }
        return UtilJobs.createJobObjFromJson((JSONObject)response.getResponsePhrase().orElseThrow(() -> new Exception("response phrase missing")));
    }

    public Job submitJcl(String jcl, String internalReaderRecfm, String internalReaderLrecl) throws Exception {
        return this.submitJclCommon(new SubmitJclParams(jcl, internalReaderRecfm, internalReaderLrecl));
    }

    public Job submitJclCommon(SubmitJclParams params) throws Exception {
        JSONObject json;
        Util.checkNullParameter(params == null, "params is null");
        Util.checkIllegalParameter(params.getJcl().isEmpty(), "jcl not specified");
        Util.checkIllegalParameter(params.getJcl().get().isEmpty(), "jcl not specified");
        HashMap<String, String> headers = new HashMap<String, String>();
        String key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_INTRDR_MODE_TEXT").get(0);
        String value = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_INTRDR_MODE_TEXT").get(1);
        headers.put(key, value);
        if (params.getInternalReaderLrecl().isPresent()) {
            key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_INTRDR_LRECL").get(0);
            headers.put(key, params.getInternalReaderLrecl().get());
        } else {
            key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_INTRDR_LRECL_80").get(0);
            value = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_INTRDR_LRECL_80").get(1);
            headers.put(key, value);
        }
        if (params.getInternalReaderRecfm().isPresent()) {
            key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_INTRDR_RECFM").get(0);
            headers.put(key, params.getInternalReaderLrecl().get());
        } else {
            key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_INTRDR_RECFM_F").get(0);
            value = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_INTRDR_RECFM_F").get(1);
            headers.put(key, value);
        }
        if (params.getJclSymbols().isPresent()) {
            // empty if block
        }
        key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_INTRDR_CLASS_A").get(0);
        value = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_INTRDR_CLASS_A").get(1);
        headers.put(key, value);
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restjobs/jobs";
        LOG.debug(url);
        String body = params.getJcl().get();
        ZoweRequest request = ZoweRequestFactory.buildRequest(this.connection, url, body, ZoweRequestType.VerbType.PUT_TEXT);
        request.setAdditionalHeaders(headers);
        Response response = request.executeHttpRequest();
        if (response.isEmpty()) {
            return new Job.Builder().build();
        }
        try {
            UtilRest.checkHttpErrors(response);
        }
        catch (Exception e) {
            String errorMsg = e.getMessage();
            if (errorMsg.contains("400")) {
                throw new Exception("Body sent may be invalid. " + errorMsg);
            }
            if (errorMsg.contains("401")) {
                throw new Exception("Unauthorized user specified. " + errorMsg);
            }
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
        JSONParser parser = new JSONParser();
        try {
            json = (JSONObject)parser.parse((String)response.getResponsePhrase().orElse(""));
        }
        catch (ParseException e) {
            throw new Exception(e.getMessage());
        }
        return UtilJobs.createJobObjFromJson(json);
    }
}

