/*
 * Decompiled with CFR 0.152.
 */
package utility;

import org.json.simple.JSONObject;
import utility.Util;
import zosjobs.input.ModifyJobParams;
import zosjobs.response.Job;

public class UtilJobs {
    public static Job createJobObjFromJson(JSONObject json) {
        Util.checkNullParameter(json == null, "json is null");
        return new Job.Builder().jobId((String)json.get("jobid")).jobName((String)json.get("jobname")).subSystem((String)json.get("subsystem")).owner((String)json.get("owner")).type((String)json.get("type")).status((String)json.get("status")).url((String)json.get("url")).classs((String)json.get("class")).filesUrl((String)json.get("files-url")).retCode((String)json.get("retcode")).jobCorrelator((String)json.get("job-correlator")).phaseName((String)json.get("phase-name")).build();
    }

    public static void checkModifyJobParameters(ModifyJobParams params) {
        Util.checkNullParameter(params == null, "params is null");
        Util.checkIllegalParameter(params.getJobId().isEmpty(), "job id not specified");
        Util.checkIllegalParameter(params.getJobId().get().isEmpty(), "job id not specified");
        Util.checkIllegalParameter(params.getJobName().isEmpty(), "job name not specified");
        Util.checkIllegalParameter(params.getJobName().get().isEmpty(), "job name not specified");
    }

    public static void throwHttpException(ModifyJobParams params, Exception exception) throws Exception {
        UtilJobs.checkModifyJobParameters(params);
        String errorMsg = exception.getMessage();
        if (errorMsg.contains("400")) {
            throw new Exception(errorMsg + " JobId " + params.getJobId().orElse("n/a") + " may not exist.");
        }
        throw new Exception(errorMsg);
    }
}

