/*
 * Decompiled with CFR 0.152.
 */
package zosfiles;

import core.ZOSConnection;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import rest.Response;
import rest.ZosmfHeaders;
import rest.ZoweRequest;
import rest.ZoweRequestFactory;
import rest.ZoweRequestType;
import utility.Crud;
import utility.Util;
import utility.UtilDataset;
import utility.UtilRest;
import utility.UtilZosFiles;
import zosfiles.input.DownloadParams;

public class ZosDsnDownload {
    private static final Logger LOG = LogManager.getLogger(ZosDsnDownload.class);
    private final ZOSConnection connection;

    public ZosDsnDownload(ZOSConnection connection) {
        Util.checkConnection(connection);
        this.connection = connection;
    }

    public InputStream downloadDsn(String dataSetName, DownloadParams params) throws Exception {
        Util.checkNullParameter(params == null, "params is null");
        Util.checkNullParameter(dataSetName == null, "dataSetName is null");
        Util.checkIllegalParameter(dataSetName.isEmpty(), "dataSetName not specified");
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restfiles/ds/";
        if (params.getVolume().isPresent()) {
            url = url + params.getVolume().get();
        }
        url = url + Util.encodeURIComponent(dataSetName);
        LOG.debug(url);
        Map<String, String> headers = UtilZosFiles.generateHeadersBasedOnOptions(params);
        if (params.getReturnEtag().isPresent()) {
            String key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_RETURN_ETAG").get(0);
            String value = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_RETURN_ETAG").get(1);
            headers.put(key, value);
        }
        ZoweRequest request = ZoweRequestFactory.buildRequest(this.connection, url, null, ZoweRequestType.VerbType.GET_STREAM);
        request.setHeaders(headers);
        Response response = request.executeRequest();
        if (response.isEmpty()) {
            return null;
        }
        try {
            UtilRest.checkHttpErrors(response);
        }
        catch (Exception e) {
            UtilDataset.checkHttpErrors(e.getMessage(), Arrays.asList(dataSetName), Crud.type.download);
        }
        return response.getResponsePhrase().orElse(null);
    }
}

