/*
 * Decompiled with CFR 0.152.
 */
package zosfiles.input;

import java.util.Optional;

public class CopyParams {
    private final Optional<String> fromVolser;
    private final Optional<String> fromDataSet;
    private final Optional<String> toVolser;
    private final Optional<String> toDataSet;
    private final boolean replace;
    private final boolean copyAllMembers;

    private CopyParams(Builder builder) {
        this.fromVolser = Optional.ofNullable(builder.fromVolser);
        this.fromDataSet = Optional.ofNullable(builder.fromDataSet);
        this.toVolser = Optional.ofNullable(builder.toVolser);
        this.toDataSet = Optional.ofNullable(builder.toDataSet);
        this.replace = builder.replace;
        this.copyAllMembers = builder.copyAllMembers;
    }

    public Optional<String> getFromVolser() {
        return this.fromVolser;
    }

    public Optional<String> getFromDataSet() {
        return this.fromDataSet;
    }

    public Optional<String> getToVolser() {
        return this.toVolser;
    }

    public Optional<String> getToDataSet() {
        return this.toDataSet;
    }

    public boolean isReplace() {
        return this.replace;
    }

    public boolean isCopyAllMembers() {
        return this.copyAllMembers;
    }

    public String toString() {
        return "CopyParams{fromVolser=" + this.fromVolser + ", fromDataSet=" + this.fromDataSet + ", toVolser=" + this.toVolser + ", toDataSet=" + this.toDataSet + ", replace=" + this.replace + "}";
    }

    public static class Builder {
        private String fromVolser;
        private String fromDataSet;
        private String toVolser;
        private String toDataSet;
        private boolean replace = true;
        private boolean copyAllMembers = false;

        public Builder fromVolser(String volser) {
            this.fromVolser = volser;
            return this;
        }

        public Builder fromDataSet(String dataSet) {
            this.fromDataSet = dataSet;
            return this;
        }

        public Builder toVolser(String volser) {
            this.toVolser = volser;
            return this;
        }

        public Builder toDataSet(String dataSet) {
            this.toDataSet = dataSet;
            return this;
        }

        public Builder replace(boolean replace) {
            this.replace = replace;
            return this;
        }

        public Builder copyAllMembers(boolean value) {
            this.copyAllMembers = value;
            return this;
        }

        public CopyParams build() {
            return new CopyParams(this);
        }
    }
}

