/*
 * Decompiled with CFR 0.152.
 */
package zosfiles.input;

import java.util.HashMap;
import java.util.Optional;

public class DownloadParams {
    private final Optional<String> file;
    private final Optional<String> extension;
    private final Optional<String> directory;
    private final Optional<String[]> excludePatterns;
    private final Optional<HashMap<String, String>> extensionMap;
    private final Optional<Integer> maxConcurrentRequests;
    private final Optional<Boolean> returnEtag;
    private final Optional<Boolean> preserveOriginalLetterCase;
    private final Optional<Boolean> failFast;
    private final Optional<Boolean> binary;
    private final Optional<Integer> encoding;
    private final Optional<String> volume;
    private final Optional<String> task;
    private final Optional<String> responseTimeout;

    private DownloadParams(Builder builder) {
        this.file = Optional.ofNullable(builder.file);
        this.extension = Optional.ofNullable(builder.extension);
        this.directory = Optional.ofNullable(builder.directory);
        this.excludePatterns = Optional.ofNullable(builder.excludePatterns);
        this.extensionMap = Optional.ofNullable(builder.extensionMap);
        this.maxConcurrentRequests = Optional.ofNullable(builder.maxConcurrentRequests);
        this.returnEtag = Optional.ofNullable(builder.returnEtag);
        this.preserveOriginalLetterCase = Optional.ofNullable(builder.preserveOriginalLetterCase);
        this.failFast = Optional.ofNullable(builder.failFast);
        this.binary = Optional.ofNullable(builder.binary);
        this.encoding = Optional.ofNullable(builder.encoding);
        this.volume = Optional.ofNullable(builder.volume);
        this.task = Optional.ofNullable(builder.task);
        this.responseTimeout = Optional.ofNullable(builder.responseTimeout);
    }

    public Optional<String> getFile() {
        return this.file;
    }

    public Optional<String> getExtension() {
        return this.extension;
    }

    public Optional<String> getDirectory() {
        return this.directory;
    }

    public Optional<String[]> getExcludePatterns() {
        return this.excludePatterns;
    }

    public Optional<HashMap<String, String>> getExtensionMap() {
        return this.extensionMap;
    }

    public Optional<Integer> getNaxConcurrentRequests() {
        return this.maxConcurrentRequests;
    }

    public Optional<Boolean> getReturnEtag() {
        return this.returnEtag;
    }

    public Optional<Boolean> getPreserveOriginalLetterCase() {
        return this.preserveOriginalLetterCase;
    }

    public Optional<Boolean> getFailFast() {
        return this.failFast;
    }

    public Optional<Boolean> getBinary() {
        return this.binary;
    }

    public Optional<Integer> getEncoding() {
        return this.encoding;
    }

    public Optional<String> getVolume() {
        return this.volume;
    }

    public Optional<String> getTask() {
        return this.task;
    }

    public Optional<String> getResponseTimeout() {
        return this.responseTimeout;
    }

    public String toString() {
        return "DownloadOptions{file=" + this.file + ", extension=" + this.extension + ", directory=" + this.directory + ", excludePatterns=" + this.excludePatterns + ", extensionMap=" + this.extensionMap + ", maxConcurrentRequests=" + this.maxConcurrentRequests + ", returnEtag=" + this.returnEtag + ", preserveOriginalLetterCase=" + this.preserveOriginalLetterCase + ", failFast=" + this.failFast + ", binary=" + this.binary + ", encoding=" + this.encoding + ", volume=" + this.volume + ", task=" + this.task + ", responseTimeout=" + this.responseTimeout + "}";
    }

    public static class Builder {
        private String file;
        private String extension;
        private String directory;
        private String[] excludePatterns;
        private HashMap<String, String> extensionMap;
        private Integer maxConcurrentRequests;
        private Boolean returnEtag;
        private Boolean preserveOriginalLetterCase;
        private Boolean failFast;
        private Boolean binary;
        private Integer encoding;
        private String volume;
        private String task;
        private String responseTimeout;

        public Builder file(String file) {
            this.file = file;
            return this;
        }

        public Builder extension(String extension) {
            this.extension = extension;
            return this;
        }

        public Builder directory(String directory) {
            this.directory = directory;
            return this;
        }

        public Builder excludePatterns(String[] excludePatterns) {
            this.excludePatterns = excludePatterns;
            return this;
        }

        public Builder extensionMap(HashMap<String, String> extensionMap) {
            this.extensionMap = extensionMap;
            return this;
        }

        public Builder maxConcurrentRequests(Integer maxConcurrentRequests) {
            this.maxConcurrentRequests = maxConcurrentRequests;
            return this;
        }

        public Builder returnEtag(Boolean returnEtag) {
            this.returnEtag = returnEtag;
            return this;
        }

        public Builder preserveOriginalLetterCase(Boolean preserveOriginalLetterCase) {
            this.preserveOriginalLetterCase = preserveOriginalLetterCase;
            return this;
        }

        public Builder failFast(Boolean failFast) {
            this.failFast = failFast;
            return this;
        }

        public Builder binary(Boolean binary) {
            this.binary = binary;
            return this;
        }

        public Builder encoding(Integer encoding) {
            this.encoding = encoding;
            return this;
        }

        public Builder volume(String volume) {
            this.volume = volume;
            return this;
        }

        public Builder task(String task) {
            this.task = task;
            return this;
        }

        public Builder responseTimeout(String responseTimeout) {
            this.responseTimeout = responseTimeout;
            return this;
        }

        public DownloadParams build() {
            return new DownloadParams(this);
        }
    }
}

