/*
 * Decompiled with CFR 0.152.
 */
package zosjobs;

import core.ZOSConnection;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import rest.Response;
import rest.ZosmfHeaders;
import rest.ZoweRequest;
import rest.ZoweRequestFactory;
import rest.ZoweRequestType;
import utility.Util;
import utility.UtilJobs;
import utility.UtilRest;
import zosjobs.input.ModifyJobParams;
import zosjobs.response.Job;

public class DeleteJobs {
    private static final Logger LOG = LogManager.getLogger(DeleteJobs.class);
    private final ZOSConnection connection;

    public DeleteJobs(ZOSConnection connection) {
        Util.checkConnection(connection);
        this.connection = connection;
    }

    public Response deleteJob(String jobName, String jobId, String version) throws Exception {
        return this.deleteJobCommon(new ModifyJobParams.Builder(jobName, jobId).version(version).build());
    }

    public Response deleteJobForJob(Job job, String version) throws Exception {
        return this.deleteJobCommon(new ModifyJobParams.Builder(job.getJobName().orElse(null), job.getJobId().orElse(null)).version(version).build());
    }

    public Response deleteJobCommon(ModifyJobParams params) throws Exception {
        UtilJobs.checkModifyJobParameters(params);
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/restjobs/jobs/" + params.getJobName().get() + "/" + params.getJobId().get();
        LOG.debug(url);
        HashMap<String, String> headers = new HashMap<String, String>();
        String version = params.getVersion().orElse("1.0");
        if (!version.isEmpty()) {
            if ("1.0".equals(version)) {
                LOG.debug("version 1.0 specified which will result in asynchronous processing for the request");
                headers.put((String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_JOB_MODIFY_VERSION_1").get(0), (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_JOB_MODIFY_VERSION_1").get(1));
            } else if ("2.0".equals(version)) {
                LOG.debug("version 2.0 specified which will result in synchronous processing for the request");
                headers.put((String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_JOB_MODIFY_VERSION_2").get(0), (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_JOB_MODIFY_VERSION_2").get(1));
            } else {
                throw new Exception("invalid version specified");
            }
        }
        ZoweRequest request = ZoweRequestFactory.buildRequest(this.connection, url, null, ZoweRequestType.VerbType.DELETE_JSON);
        request.setHeaders(headers);
        Response response = request.executeRequest();
        try {
            UtilRest.checkHttpErrors(response);
        }
        catch (Exception e) {
            UtilJobs.throwHttpException(params, e);
        }
        return response;
    }
}

