/*
 * Decompiled with CFR 0.152.
 */
package zostso;

import core.ZOSConnection;
import java.util.ArrayList;
import utility.Util;
import zostso.IssueResponse;
import zostso.SendResponse;
import zostso.SendTso;
import zostso.StartStopResponse;
import zostso.StartStopResponses;
import zostso.StartTso;
import zostso.StopTso;
import zostso.input.StartTsoParams;
import zostso.zosmf.ZosmfTsoResponse;

public class IssueTso {
    private final ZOSConnection connection;

    public IssueTso(ZOSConnection connection) {
        Util.checkConnection(connection);
        this.connection = connection;
    }

    public IssueResponse issueTsoCommand(String accountNumber, String command) throws Exception {
        return this.issueTsoCommand(accountNumber, command, null);
    }

    public IssueResponse issueTsoCommand(String accountNumber, String command, StartTsoParams startParams) throws Exception {
        Util.checkNullParameter(accountNumber == null, "accountNumber is null");
        Util.checkNullParameter(command == null, "command is null");
        Util.checkIllegalParameter(accountNumber.isEmpty(), "accountNumber not specified");
        Util.checkIllegalParameter(command.isEmpty(), "command not specified");
        StartTso startTso = new StartTso(this.connection);
        StartStopResponses startResponse = startTso.start(accountNumber, startParams);
        if (startResponse == null) {
            throw new Exception("Severe failure getting started TSO address space.");
        }
        if (!startResponse.isSuccess()) {
            throw new Exception("TSO address space failed to start. Error: " + startResponse.getFailureResponse().orElse("Unknown error"));
        }
        IssueResponse issueResponse = new IssueResponse();
        issueResponse.setStartResponse(startResponse);
        ArrayList<ZosmfTsoResponse> zosmfTsoResponses = new ArrayList<ZosmfTsoResponse>();
        zosmfTsoResponses.add(startResponse.getZosmfTsoResponse().orElseThrow(() -> new Exception("no zosmf start tso response")));
        String servletKey = startResponse.getServletKey().orElseThrow(() -> new Exception("no servletKey key value returned from startTso"));
        SendTso sendTso = new SendTso(this.connection);
        SendResponse sendResponse = sendTso.sendDataToTSOCollect(servletKey, command);
        issueResponse.setSuccess(sendResponse.getSuccess());
        zosmfTsoResponses.addAll(sendResponse.getZosmfResponses());
        issueResponse.setZosmfResponses(zosmfTsoResponses);
        issueResponse.setCommandResponses(sendResponse.getCommandResponse().orElseThrow(() -> new Exception("error getting command response")));
        StopTso stopTso = new StopTso(this.connection);
        StartStopResponse stopResponse = stopTso.stop(servletKey);
        issueResponse.setStopResponse(stopResponse);
        return issueResponse;
    }
}

