/*
 * Decompiled with CFR 0.152.
 */
package zostso;

import core.ZOSConnection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.simple.JSONObject;
import rest.Response;
import rest.ZoweRequest;
import rest.ZoweRequestFactory;
import rest.ZoweRequestType;
import utility.Util;
import utility.UtilRest;
import utility.UtilTso;
import zostso.StartStopResponse;
import zostso.input.StopTsoParams;
import zostso.zosmf.ZosmfTsoResponse;

public class StopTso {
    private static final Logger LOG = LogManager.getLogger(StopTso.class);
    private final ZOSConnection connection;

    public StopTso(ZOSConnection connection) {
        Util.checkConnection(connection);
        this.connection = connection;
    }

    public ZosmfTsoResponse stopCommon(StopTsoParams commandParams) throws Exception {
        Util.checkNullParameter(commandParams == null, "commandParams is null");
        Util.checkIllegalParameter(commandParams.getServletKey().isEmpty(), "servletKey not specified");
        Util.checkIllegalParameter(commandParams.getServletKey().get().isEmpty(), "servletKey not specified");
        String url = "https://" + this.connection.getHost() + ":" + this.connection.getZosmfPort() + "/zosmf/tsoApp/tso/" + commandParams.getServletKey().get();
        LOG.debug("StopTso::stopCommon url {}", (Object)url);
        ZoweRequest request = ZoweRequestFactory.buildRequest(this.connection, url, null, ZoweRequestType.VerbType.DELETE_JSON);
        Response response = request.executeRequest();
        if (response.isEmpty()) {
            return new ZosmfTsoResponse.Builder().build();
        }
        try {
            UtilRest.checkHttpErrors(response);
        }
        catch (Exception e) {
            String errorMsg = e.getMessage();
            throw new Exception("Failed to stop active TSO address space. " + errorMsg);
        }
        JSONObject result = response.getResponsePhrase().orElse(null);
        return UtilTso.parseJsonStopResponse(result);
    }

    public StartStopResponse stop(String servletKey) throws Exception {
        Util.checkNullParameter(servletKey == null, "servletKey is null");
        Util.checkIllegalParameter(servletKey.isEmpty(), "servletKey not specified");
        StopTsoParams commandParams = new StopTsoParams(servletKey);
        ZosmfTsoResponse zosmfResponse = this.stopCommon(commandParams);
        return UtilTso.populateStartAndStop(zosmfResponse);
    }
}

