/*
 * Decompiled with CFR 0.152.
 */
package examples.zosjobs;

import core.ZOSConnection;
import examples.ZosConnection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import zosjobs.SubmitJobs;
import zosjobs.response.Job;
import zosjobs.types.JobStatus;

public class MonitorJobs
extends ZosConnection {
    private static final Logger LOG = LogManager.getLogger(MonitorJobs.class);
    private static SubmitJobs submitJobs;
    private static ZOSConnection connection;

    public static void main(String[] args) throws Exception {
        connection = new ZOSConnection("XXX", "XXX", "XXX", "XXX");
        submitJobs = new SubmitJobs(connection);
        MonitorJobs.monitorJobsForOutputStatusByJobObject();
        MonitorJobs.monitorJobsForOutputStatusByJobNameAndId();
        MonitorJobs.monitorJobsForStatusByJobObject(JobStatus.Type.INPUT);
        MonitorJobs.monitorJobsForStatusByJobNameAndId(JobStatus.Type.ACTIVE);
        MonitorJobs.monitorWaitForJobMessage("XXX");
    }

    public static void monitorJobsForOutputStatusByJobObject() throws Exception {
        String jclString = "//TESTJOBX JOB (),MSGCLASS=H\r // EXEC PGM=IEFBR14";
        Job job = submitJobs.submitJcl(jclString, null, null);
        zosjobs.MonitorJobs monitorJobs = new zosjobs.MonitorJobs(connection);
        job = monitorJobs.waitForJobOutputStatus(job);
        LOG.info("Job status for Job " + job.getJobName().orElse("n/a") + ":" + job.getJobId().orElse("n/a") + " is " + job.getStatus().orElse("n/a"));
    }

    public static void monitorJobsForOutputStatusByJobNameAndId() throws Exception {
        String jclString = "//TESTJOBX JOB (),MSGCLASS=H\r // EXEC PGM=IEFBR14";
        Job job = submitJobs.submitJcl(jclString, null, null);
        zosjobs.MonitorJobs monitorJobs = new zosjobs.MonitorJobs(connection);
        job = monitorJobs.waitForJobOutputStatus(job.getJobName().orElseThrow(() -> new Exception("job name not specified")), job.getJobId().orElseThrow(() -> new Exception("job id not specified")));
        LOG.info("Job status for Job " + job.getJobName().orElse("n/a") + ":" + job.getJobId().orElse("n/a") + " is " + job.getStatus().orElse("n/a"));
    }

    public static void monitorJobsForStatusByJobObject(JobStatus.Type statusType) throws Exception {
        Job job = new Job.Builder().jobName("XXX").jobId("XXX").build();
        zosjobs.MonitorJobs monitorJobs = new zosjobs.MonitorJobs(connection);
        job = monitorJobs.waitForJobStatus(job, statusType);
        LOG.info("Job status for Job " + job.getJobName().orElse("n/a") + ":" + job.getJobId().orElse("n/a") + " is " + job.getStatus().orElse("n/a"));
    }

    public static void monitorJobsForStatusByJobNameAndId(JobStatus.Type statusType) throws Exception {
        Job job = new Job.Builder().jobName("XXX").jobId("XXX").build();
        zosjobs.MonitorJobs monitorJobs = new zosjobs.MonitorJobs(connection);
        job = monitorJobs.waitForJobStatus(job.getJobName().orElseThrow(() -> new Exception("job name not specified")), job.getJobId().orElseThrow(() -> new Exception("job id not specified")), statusType);
        LOG.info("Job status for Job " + job.getJobName().orElse("n/a") + ":" + job.getJobId().orElse("n/a") + " is " + job.getStatus().orElse("n/a"));
    }

    public static void monitorWaitForJobMessage(String message) throws Exception {
        Job job = new Job.Builder().jobName("XXX").jobId("XXX").build();
        zosjobs.MonitorJobs monitorJobs = new zosjobs.MonitorJobs(connection);
        LOG.info("Found message = " + monitorJobs.waitForJobMessage(job, message));
    }
}

