/*
 * Decompiled with CFR 0.152.
 */
package rest;

import core.ZOSConnection;
import rest.JsonDeleteRequest;
import rest.JsonGetRequest;
import rest.JsonPostRequest;
import rest.JsonPutRequest;
import rest.StreamGetRequest;
import rest.TextGetRequest;
import rest.TextPutRequest;
import rest.ZoweRequest;
import rest.ZoweRequestType;

public class ZoweRequestFactory {
    public static ZoweRequest buildRequest(ZOSConnection connection, String url, String body, ZoweRequestType.VerbType type) throws Exception {
        ZoweRequest request;
        switch (type) {
            case GET_JSON: {
                request = new JsonGetRequest(connection, url);
                break;
            }
            case PUT_JSON: {
                request = new JsonPutRequest(connection, url, body);
                break;
            }
            case POST_JSON: {
                request = new JsonPostRequest(connection, url, body);
                break;
            }
            case DELETE_JSON: {
                request = new JsonDeleteRequest(connection, url);
                break;
            }
            case GET_TEXT: {
                request = new TextGetRequest(connection, url);
                break;
            }
            case PUT_TEXT: {
                request = new TextPutRequest(connection, url, body);
                break;
            }
            case GET_STREAM: {
                request = new StreamGetRequest(connection, url);
                break;
            }
            default: {
                throw new Exception("no valid type specified");
            }
        }
        return request;
    }
}

