/*
 * Decompiled with CFR 0.152.
 */
package utility;

import utility.Util;
import zosconsole.ConsoleResponse;
import zosconsole.zosmf.ZosmfIssueResponse;

public class UtilConsole {
    public static void populate(ZosmfIssueResponse zosmfResponse, ConsoleResponse response, boolean processResponses) {
        Util.checkNullParameter(zosmfResponse == null, "zosmfResponse is null");
        Util.checkNullParameter(response == null, "response is null");
        response.setZosmfResponse(zosmfResponse);
        response.setSuccess(true);
        if (zosmfResponse.getSolKeyDetected().isPresent()) {
            response.setKeywordDetected(true);
        }
        if (zosmfResponse.getCmdResponse().isPresent() && zosmfResponse.getCmdResponse().get().length() > 0 && processResponses) {
            String responseValue = zosmfResponse.getCmdResponse().get().replace('\r', '\n');
            response.setCommandResponse(responseValue);
            if (responseValue.length() > 0 && responseValue.indexOf("\n") != responseValue.length() - 1) {
                response.setCommandResponse(responseValue + "\n");
            }
        }
        zosmfResponse.getCmdResponseKey().ifPresent(response::setLastResponseKey);
        zosmfResponse.getCmdResponseUrl().ifPresent(response::setCmdResponseUrl);
    }
}

